%def_enable tests

Name: libldb
Version: 1.1.27
Release: alt0.M70P.1
Summary: A schema-less, ldap like, API and database
License: LGPLv3+
Group: System/Libraries
Url: http://ldb.samba.org/

Source: http://samba.org/ftp/ldb/ldb-%{version}.tar.gz
Source1: ldb-modules.sh

BuildRequires: python-devel python-module-tdb libpytalloc-devel python-module-tevent
BuildRequires: libtalloc-devel libtdb-devel libtevent-devel libpopt-devel libldap-devel xsltproc docbook-style-xsl docbook-dtds

%description
An extensible library that implements and LDAP like API to access remote LDAP
servers, or use local tdb databases.

%package devel
Group: Development/C
Summary: Developer tools for the LDB library
Requires: %name = %version-%release

%description devel
Header files needed to develop programs that link against the LDB library.

%package -n ldb-tools
Group: Development/Tools
Summary: Tools to manage LDB files
Requires: %name = %version-%release

%description -n ldb-tools
Tools to manage LDB files

%package -n python-module-pyldb
Group: Development/Python
Summary: Python bindings for the LDB library
Requires: %name = %version-%release

%description -n python-module-pyldb
Python bindings for the LDB library

%package -n python-module-pyldb-devel
Group: Development/Python
Summary: Development files for the Python bindings for the LDB library
Requires: python-module-pyldb = %version-%release
Requires: %name-devel = %version-%release

%description -n python-module-pyldb-devel
Development files for the Python bindings for the LDB library

%prep
%setup -n ldb-%version

%build
%undefine _configure_gettext
%configure	\
		--disable-rpath \
		--disable-rpath-install \
		--bundled-libraries=NONE \
		--builtin-libraries=replace \
		--with-modulesdir=%_libdir/ldb/modules \
		--with-privatelibdir=%_libdir/ldb
%make

%install
%makeinstall_std

install -D -m755 %SOURCE1 %buildroot%_sysconfdir/bashrc.d/ldb-modules.sh
sed -i s,@libdir@,%_libdir,g %buildroot%_sysconfdir/bashrc.d/ldb-modules.sh

rm -f %buildroot%_libdir/*.a
rm -f %buildroot/%_man3dir/_*

%if_enabled tests
%check
export LD_LIBRARY_PATH=./bin/shared:./bin/shared/private:$LD_LIBRARY_PATH
export LDB_MODULES_PATH=./bin/modules/ldb:$LDB_MODULES_PATH
make test
%endif

%files
%_libdir/libldb.so.*
%dir %_libdir/ldb
%dir %_libdir/ldb/modules
%dir %_libdir/ldb/modules/ldb
%_libdir/ldb/modules/ldb/*.so

%files devel
%_includedir/*.h
%_libdir/*.so
%_pkgconfigdir/ldb.pc
%_man3dir/*

%exclude %_includedir/pyldb.h
%exclude %_libdir/libpyldb-util.so

%files -n ldb-tools
%_sysconfdir/bashrc.d/ldb-modules.sh
%_bindir/*
%_man1dir/*
%_libdir/ldb/libldb-cmdline.so

%files -n python-module-pyldb
%python_sitelibdir/ldb.so
%python_sitelibdir/_ldb_text.py*
%_libdir/libpyldb-util.so.1*

%files -n python-module-pyldb-devel
%_includedir/pyldb.h
%_libdir/libpyldb-util.so
%_pkgconfigdir/pyldb-util.pc

%changelog
