# This spec is backported to ALTLinux p7 automatically by rpmbph script from etersoft-build-utils.
#
Name: liblttng-ust
Version: 2.8.3
Release: alt0.M70P.1

Summary: Linux Trace Toolkit Userspace Tracer library

License: GPLv2
Group: Development/C++
Url: http://lttng.org/lttng2.0

# Source-url: http://lttng.org/files/lttng-ust/lttng-ust-%version.tar.bz2
Source: %name-%version.tar

Patch2: lttng-ust-aarch64-aligned-access.patch

BuildRequires: gcc-c++
BuildRequires: libuserspace-rcu-devel
BuildRequires: libuuid-devel

# for man pages
BuildRequires: asciidoc xmlto

ExclusiveArch: aarch64 %ix86 x86_64

%description
This library may be used by user space applications to generate tracepoints within the kernel LTT subsystem.

%package devel

Summary: Linux Trace Toolkit Userspace Tracer library
Group: Development/C++
Requires: %name = %version-%release
Requires: libuserspace-rcu-devel

%description devel
This library provides support for developing programs using LTTng userspace tracing.

%package docs

Summary: Linux Trace Toolkit Userspace Tracer Documentation
Group: Development/C++
Requires: %name = %version-%release

%description docs
This package includes documentation and examples for developing programs using LTTng userspace tracing.

%prep
%setup
#patch2 -p1

#cp -l README.md README

%build
# to fix rpath
%autoreconf
%configure --docdir=%_docdir/%name --disable-static --disable-maintainer-mode
%make_build

%install
%makeinstall_std
rm -vf %buildroot%_libdir/*.la
rm -rf %buildroot/tmp/lttng-ust-divert

%files
%_bindir/lttng-gen-tp
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/lttng-ust*.pc

%files docs
%dir %_docdir/%name/
%_docdir/%name/ChangeLog
%_docdir/%name/README.md
#_docdir/%name/COPYING
%dir %_docdir/%name/examples
%_docdir/%name/examples/*
%_docdir/%name/java-agent.txt
%_man1dir/lttng-gen-tp.1.*
%_man3dir/lttng-ust.3.*
%_man3dir/lttng-ust-cyg-profile.3.*
%_man3dir/lttng-ust-dl.3.*
%_man3dir/do_tracepoint.3.*
%_man3dir/tracef.3.*
%_man3dir/tracelog.3.*
%_man3dir/tracepoint.3.*
%_man3dir/tracepoint_enabled.3.*

%changelog
