%define major 4
%define oname netcdf
%define sname lib%oname
%define sover 7
%define c_sover 4
%define c4_sover 1
%define f_sover 5
%define priority 30
%define hdfdir %_libdir/hdf5-seq

Name: %sname%sover-seq
Version: %major.2.1.1
Release: alt2

Summary: Libraries to use the Unidata network Common Data Form (netCDF)

License: NetCDF
Group: System/Libraries
Url: http://www.unidata.ucar.edu/packages/netcdf/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Requires(post,preun): alternatives
Requires: libhdf5-7-seq
Conflicts: %sname-mpi < 4.0.1-alt6 %oname%sover-mpi-tools < 4.0.1-alt6
Conflicts: %sname-mpi-devel-doc
Provides: %sname = %version-%release
Provides: %sname%sover = %version-%release
Conflicts: %sname%sover < %version-%release
Obsoletes: %sname%sover < %version-%release
%ifarch x86_64
Provides: %sname.so.%sover()(64bit)
%else
Provides: %sname.so.%sover
%endif

Source: %oname-%version.tar

# Automatically added by buildreq on Sun Jan 18 2009
BuildRequires: flex gcc-c++ gcc-fortran zlib-devel libhdf5-devel

BuildPreReq: /usr/bin/tex libcurl-devel libexpat-devel doxygen graphviz

%description
NetCDF (network Common Data Form) is an interface for array-oriented
data access and a freely-distributed collection of software libraries
for C, Fortran, C++, and perl that provides an implementation of the
interface.
The netCDF library also defines a machine-independent format for
representing scientific data. Together, the interface, library, and
format support the creation, access, and sharing of scientific data. The
netCDF software was developed at the Unidata Program Center in Boulder,
Colorado.

NetCDF data is:

   o Self-Describing. A netCDF file includes information about the data
     it contains.

   o Network-transparent. A netCDF file is represented in a form that
     can be accessed by computers with different ways of storing
     integers, characters, and floating-point numbers.

   o Direct-access. A small subset of a large dataset may be accessed
     efficiently, without first reading through all the preceding data.

   o Appendable. Data can be appended to a netCDF dataset along one
     dimension without copying the dataset or redefining its structure.
     The structure of a netCDF dataset can be changed, though this
     sometimes causes the dataset to be copied.

   o Sharable. One writer and multiple readers may simultaneously
     access the same netCDF file.

%description -l ru_RU.UTF-8
NetCDF (network Common Data Form) - это ориентированный на массивы
интерфейс для доступа к данным и, одновременно, свободно
распространяемая коллекция программ и библиотек для C, Fortran, C++,
которые реализуют этот интерфейс. Программы netCDF были
разработаны Гленом Дэвисом (Glenn Davis), Руссом Рью (Russ Rew),
Стивом Еммерсоном (Steve Emmerson), Джоном Кэроном (John Caron) и
Харвей Дэвисом (Harvey Davies) в Unidata Program Center в Боулдере,
Колорадо и расширены вкладами от других пользователей netCDF.
Библиотеки netCDF определяют машиннонезависимый  формат для
представления научных данных. Интерфейс, библиотеки и сам формат
поддерживают создание, доступ и совместное использование научных
данных.

%package -n %sname-devel
Summary: Development tools for the NetCDF library
Summary(ru_RU.UTF-8): Средства разработки программ на основе библиотеки NetCDF
Group: Development/C
Requires(post,preun): alternatives
Requires: %name = %version-%release
Conflicts: %sname-mpi-devel < 4.0.1-alt6

%description -n %sname-devel
This package contains the netCDF-3 header files, shared devel libs, and
man pages.

If you want to develop applications which will use the NetCDF library,
you'll need to install the %sname-devel package.

%description -l ru_RU.UTF-8 -n %sname-devel
Заголовочные файлы и документация для использования библиотеки NetCDF
в приложениях.

Если вы собираетесь разрабатывать приложения, которые будут
использовать библиотеку NetCDF, вам необходимо установить пакет
%sname-devel.

%package doc
Summary: Documentation for NetCDF
Summary(ru_RU.UTF-8): Документация по NetCDF
Group: Documentation
BuildArch: noarch
Conflicts: %name < %version-%release

%description doc
Documentation for NetCDF library.

%description -l ru_RU.UTF-8 doc
Документация по NetCDF.

%prep
%setup

rm -fR udunits/expat

%build
%add_optflags -I%hdfdir/include -fno-strict-aliasing %optflags_shared
%autoreconf
%configure \
	--enable-shared \
	--enable-static=no \
	--bindir=%hdfdir/bin \
	--libdir=%hdfdir/lib \
	--includedir=%hdfdir/include \
	--enable-netcdf-4 \
	--enable-cxx-4 \
	--enable-docs-install \
	--enable-ncgen4 \
	--with-udunits \
	--with-hdf5=%hdfdir \
	--with-zlib=%prefix \
	--enable-doxygen \
	--enable-internal-docs \
	--enable-extra-example-tests \
	--enable-extra-tests \
	--enable-v2 \
	--enable-mmap \
	--disable-dap-remote-tests
%make

%install
%makeinstall_std

install -d %buildroot%hdfdir/include/netcdf
ln -s netcdf %buildroot%hdfdir/include/netcdf-3
install -p -m644 include/*.h %buildroot%hdfdir/include/netcdf
sed -i 's|config\.h|netcdf_config.h|' \
	%buildroot%hdfdir/include/netcdf/*
install -p -m644 config.h \
	%buildroot%hdfdir/include/netcdf/netcdf_config.h
rm -f %buildroot%hdfdir/include/netcdf/netcdf.h
mv %buildroot%hdfdir/include/*.* %buildroot%hdfdir/include/netcdf/
install -d %buildroot%_includedir
ln -s %hdfdir/include/netcdf %buildroot%_includedir/netcdf-3
ln -s %hdfdir/include/netcdf %buildroot%_includedir/netcdf
rm -f %buildroot%hdfdir/lib/*.la

install -m644 man4/man/man3/* %buildroot%_man3dir

# alternatives

install -d %buildroot%_altdir
mkdir -p %buildroot%_libdir
pushd %buildroot%hdfdir/lib
for i in %sname.so.*; do
	ln -s ../..%hdfdir/lib/$i %buildroot%_libdir/
	echo "%_libdir/$i %hdfdir/lib/$i %priority" >> \
		%buildroot%_altdir/%name.alternatives
done
for i in $(ls *.so); do
	echo "%_libdir/$i %hdfdir/lib/$i %priority" >> \
		%buildroot%_altdir/%name-devel.alternatives
done
echo "%_bindir/nc-config %hdfdir/bin/nc-config %priority" >> \
	%buildroot%_altdir/%name-devel.alternatives
echo "%_pkgconfigdir/%oname.pc %hdfdir/lib/pkgconfig/%oname.pc %priority" >> \
	%buildroot%_altdir/%name-devel.alternatives
popd
pushd %buildroot%hdfdir/bin
for i in $(ls |egrep -v 'nc\-config'); do
	echo "%_bindir/$i %hdfdir/bin/$i %priority" >> \
		%buildroot%_altdir/%name.alternatives
done
popd

%pre -n %sname-devel
rm -fR %_includedir/netcdf-3 %_includedir/netcdf \
	%hdfdir/include/netcdf-3 %hdfdir/include/netcdf

%files
%doc COPYRIGHT README RELEASE_NOTES
%hdfdir/bin/*
%exclude %hdfdir/bin/nc-config
%_man1dir/*
%ghost %_libdir/%sname.so.*
%hdfdir/lib/%sname.so.*
%_altdir/%name.alternatives

%files -n %sname-devel
%hdfdir/bin/nc-config
%hdfdir/include/netcdf-3
%hdfdir/include/netcdf
%_includedir/netcdf-3
%_includedir/netcdf
%hdfdir/lib/*.so
%hdfdir/lib/pkgconfig/*
%_man3dir/netcdf.3*
%_altdir/%name-devel.alternatives

%files doc
%doc man4/html examples
%_man3dir/*
%exclude %_man3dir/error.3*
%exclude %_man3dir/netcdf.3*

%changelog
