%def_disable static

Name: libnfsidmap
Version: 0.25
Release: alt1

Summary: Name to user id mapping library
License: BSD
Group: System/Libraries
Url: http://www.citi.umich.edu/projects/nfsv4/linux/

Source: %name-%version-%release.tar

BuildRequires: libldap-devel

Conflicts: nfs-clients < 1:1.2.4

%package ldap
Summary: Name to user id mapping library via LDAP
Group: System/Libraries
Requires: %name = %version-%release

%package devel
Summary: Name to user id mapping library and headers
Group: Development/C
Requires: %name = %version-%release

%if_enabled static
%package devel-static
Summary: Name to user id mapping static library
Group: Development/C
Requires: %name-devel = %version-%release
%endif

%description
%name is a library holding mulitiple methods of mapping names to id's
and visa versa, mainly for NFSv4.

%description ldap
%name is a package, containing LDAP method of mapping names to id's
and visa versa, mainly for NFSv4.

%description devel
%name is a library holding mulitiple methods of mapping names to id's
and visa versa, mainly for NFSv4.
This package holds development part of %name library

%if_enabled static
%description devel-static
%name is a library holding mulitiple methods of mapping names to id's
and visa versa, mainly for NFSv4.
This package contains static %name library
%endif

%prep
%setup

%build
[ ! -f autogen.sh ] || sh autogen.sh
%configure %{subst_enable static} --libdir=/%_lib --with-pluginpath=/%_lib/libnfsidmap
%make_build

%install
%makeinstall libdir=%buildroot/%_lib pkgconfigdir=%buildroot%_pkgconfigdir
install -m0644 -pD idmapd.conf %buildroot%_sysconfdir/idmapd.conf
find %buildroot/%_lib -maxdepth 1 -name \*.so|while read; do
	ln -snf ../../%_lib/`readlink $REPLY` %buildroot%_libdir/${REPLY##*/}
	rm -f -- $REPLY
done
find %buildroot -type f -name \*.la -delete
sed -i 's,/%_lib,%_libdir,' %buildroot%_pkgconfigdir/%name.pc
 
%files
%doc COPYING README
%config(noreplace) %_sysconfdir/idmapd.conf

/%_lib/%name.so.*

/%_lib/%name
%exclude /%_lib/%name/umich_ldap.*

%_man5dir/idmapd.conf.*

%files ldap
/%_lib/%name/umich_ldap.*

%files devel
%_libdir/%name.so
%_includedir/nfsidmap.h
%_pkgconfigdir/*
%_man3dir/*

%if_enabled static
%files devel-static
%_libdir/%name.a
%endif

%changelog
