%define _name nice
%def_disable static
%def_disable gtk_doc

%define gst_api_ver 1.0
%define old_gst_api_ver 0.10

Name: libnice
Version: 0.1.4
Release: alt1

Summary: Connectivity Establishment standard (ICE) library
Group: System/Libraries
License: LGPLv2+/MPL
URL: http://nice.freedesktop.org

Source: http://nice.freedesktop.org/releases/%name-%version.tar.gz

BuildRequires: glib2-devel gtk-doc libgupnp-igd-devel
BuildRequires: gst-plugins-devel
BuildRequires: gst-plugins%gst_api_ver-devel

%description
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package contains files needed to develop applications using Nice

%package devel-doc
Summary: Development documentation for %name
Group: Development/C
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package contains development documentation for %name.

%package devel-static
Summary: Static library for %name
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package contains a statically-linked variant of %name

%package -n gst-plugins-nice
Summary: UDP connectivity establishment plugin for Gstreamer based on libnice
Group: System/Libraries
Requires: %name = %version-%release

%description -n gst-plugins-nice
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package provides Interactive UDP connectivity establishment plugin
for Gstreamer

%package -n gst-plugins-nice%gst_api_ver
Summary: UDP connectivity establishment plugin for Gstreamer (1.0) based on libnice
Group: System/Libraries
Requires: %name = %version-%release

%description -n gst-plugins-nice%gst_api_ver
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package provides Interactive UDP connectivity establishment plugin
for Gstreamer (1.0 API version)

%prep
%setup -q

%build
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable static}

%make_build

%install
%make_install DESTDIR=%buildroot install

%files
%_libdir/*.so.*
%doc AUTHORS ChangeLog NEWS README

%files devel
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files -n gst-plugins-nice
%_libdir/gstreamer-%old_gst_api_ver/libgstnice010.so

%files -n gst-plugins-nice%gst_api_ver
%_libdir/gstreamer-%gst_api_ver/libgstnice.so

%exclude %_libdir/gstreamer-*/*.la

# don't package tools
%exclude %_bindir/stun*
# and example progs
%exclude %_bindir/*example

%changelog
