%define nsswitch %_sysconfdir/nsswitch.conf

Name: libnss-tartarus
Version: 0.1.1
Release: alt3.6

Summary: NSS library module for Tartarus

License: %gpl2plus
URL: http://tartarus.ru/
Group: System/Libraries
Packager: Evgeny Sinelnikov <sin@altlinux.ru>

Source: %name-%version.tar
Source1: tnscd.init.%_vendor
Patch: libnss-tartarus-0.1.1-alt-DSO.patch
Patch1: libnss-tartarus-0.1.1-alt-cxx_flags.patch

Requires: libnss-role
Requires: nss-tartarus-daemon = %version-%release
Requires: libice-ssl-krb

Requires(pre): chrooted >= 0.3.5-alt1 chrooted-resolv sed
Requires(postun): chrooted >= 0.3.5-alt1 sed

BuildRequires: libdbus-c++-etersoft-devel >= 0.5.0-alt9
BuildRequires: boost-devel >= 1:1.39.0
BuildRequires: boost-devel boost-filesystem-devel
BuildRequires: libcom_err-devel libice-devel libjson_spirit-devel libkrb5user-devel
BuildRequires: gcc-c++ cmake

BuildRequires(pre): rpm-build-licenses

BuildRequires: Tartarus-SysDB-slice
BuildRequires: libice-ssl-krb-devel
BuildRequires: libkrb5user-devel >= 0.1.0

%description
NSS library module for Tartarus.

%package -n nss-tartarus-daemon
Summary: Authorization proxy and cache daemon for Tartarus
Group: System/Servers

%description -n nss-tartarus-daemon
Authorization proxy and cache daemon for Tartarus

%prep
%setup -q
%patch -p2
%patch1 -p2

%build
mkdir build
cd build
%add_optflags -fpermissive
cmake ../ \
        -DCMAKE_INSTALL_PREFIX=/usr \
%if %_lib == lib64
        -DLIB_SUFFIX=64 \
%endif
        -DCMAKE_BUILD_TYPE="RelWithDebInfo" \
				-DCMAKE_C_FLAGS="%optflags" \
				-DCMAKE_CXX_FLAGS="%optflags"

%make_build VERBOSE=1

%install
cd build
%makeinstall DESTDIR=%buildroot

mkdir -p %buildroot%_var/run/tnscd
mkdir -p %buildroot%_initdir
cp %SOURCE1 %buildroot%_initdir/tnscd

%post
if [ "$1" = "1" ]; then
    cp %nsswitch %nsswitch.rpmorig
    grep -q '^passwd:[[:blank:]].\+tartarus' %nsswitch || \
    sed -i 's/^\(passwd:[[:blank:]].\+\)$/\1 tartarus/' %nsswitch
    if grep -q '^group:[[:blank:]].\+role' %nsswitch; then
        grep -q '^group:[[:blank:]].\+tartarus' %nsswitch || \
        sed -i 's/^\(group:[[:blank:]].\+\)\(role\)$/\1tartarus \2/' %nsswitch
    else
        grep -q '^group:[[:blank:]].\+tartarus' %nsswitch || \
        sed -i 's/^\(group:[[:blank:]].\+\)$/\1 tartarus role/' %nsswitch
    fi
fi
update_chrooted all

%postun
if [ "$1" = "0" ]; then
    sed -i -e 's/ tartarus//g' %nsswitch
fi
update_chrooted all

%post -n nss-tartarus-daemon
%post_service tnscd

%preun -n nss-tartarus-daemon
%preun_service tnscd

%files
/%_lib/libnss_*.so.*

%files -n nss-tartarus-daemon
%_sbindir/*
%_initdir/*
%_datadir/dbus-1/system-services/ru.tartarus.DBus.TNSCD.service
%_sysconfdir/dbus-1/system.d/ru.tartarus.DBus.TNSCD.conf
%config(noreplace) %_sysconfdir/Tartarus/clients/*
%dir %_var/run/tnscd

%changelog
