Name:    libomniORB
License: LGPL
URL:     http://omniorb.sourceforge.net/

Version: 4.2.0
Release: alt3.svn20130111

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source0: omniORB-%version.tar.gz
Source1: omniORB.cfg
Source2: omninames
Source3: omninames.sysconfig

Patch0: libomniORB-non-strict.patch
Patch1: libomniORB-all-cosifaces.patch

# Automatically added by buildreq on Wed Aug 26 2009
BuildRequires: gcc-c++ libssl-devel python-devel python-modules-compiler

Summary: ORB from AT&T (core libraries)
Group:   Networking/Remote access
%description
omniORB is an Object Request Broker (ORB) that implements the 2.3
specification of the Common Object Request Broker Architecture
(CORBA) [OMG99]. It has passed the Open Group CORBA compliant
testsuite and is one of the three ORBs to have been granted the CORBA
brand in June 1999.

This package contains core libraries need for all omniORB applications.

%package idl
Summary: IDL definitions shipped with omniORB
Group:   Networking/Remote access
BuildArch: noarch
%description idl
This package contains standard IDL definitions shipped with omniORB.
You need this package if you write IDL specification which uses
standard IDL definitions.

%package docs
Summary: Documentations for omniORB
Group:   Networking/Remote access
BuildArch: noarch
%description docs
This package contains documentation for omniORB.

%package COS
Summary: ORB from AT&T (COS service stub and skel libraries)
Group:   Networking/Remote access
Requires: %name = %version-%release
%description COS
This package contains libraries, compiled from auto generated
stub and skel code for COS services.

%package utils
Summary: ORB from AT&T (utilities)
Group:   Networking/Remote access
Requires: %name = %version-%release
%description utils
This package contains utilities for omniORB.

%package names
Summary: NameService implementation for omniORB
Group:   Networking/Remote access
Requires: %name = %version-%release
Requires: %name-COS = %version-%release
%description names
This package contains standard compliant NameService implementation
for omniORB.

%setup_python_subpackage omniidl
%package -n %{packagename}
Summary: Python module for omniidl
Group:   Development/C++
%setup_std_python_package_deps
%description -n %{packagename}
This package includes python files for the omniORB package.

%package devel
Summary: development part of omniORB (core definitions and tools)
Group:   Development/C++
Requires: %name = %version-%release
Requires: %packagename = %version-%release
%description devel
This devel package includes the libraries and header files
for the omniORB package.

%package devel-COS
Summary: development part of omniORB (COS headers)
Group:   Development/C++
Requires: %name-devel = %version-%release
%description devel-COS
This devel package includes the libraries and header files
for the omniORB package (COS module). You need this package if
you write applications that uses standard services and want
share COS code.

%package devel-static
Summary: development part of omniORB (core static libraries)
Group:   Development/C++
Requires: %name-devel = %version-%release
%description devel-static
This devel package includes static libraries
for the omniORB package.

%package devel-static-COS
Summary: development part of omniORB (COS static libraries)
Group:   Development/C++
Requires: %name-devel = %version-%release
%description devel-static-COS
This devel package includes static libraries
for the omniORB package (COS module).

%prep
%setup
%patch0 -p 1
%patch1 -p 1

%build
%configure \
	--disable-thread-tracing \
	--with-openssl=%_prefix \
	--with-omniORB-config=%_sysconfdir/omniORB.cfg \
	--with-omniNames-logdir=%_logdir/omniORB

%make

%install
# hasher workaround
unset target ||:
# end

%makeinstall_std

install -d -m 755 %buildroot%_logdir/omniORB
install -d -m 755 %buildroot%_man1dir
install -d -m 755 %buildroot%_initdir

cp -a man/man1/* %buildroot%_man1dir
install -p -m 644 %SOURCE1 %buildroot%_sysconfdir
install -p -D -m 755 %SOURCE2 %buildroot%_initdir/omninames
install -p -D -m 644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/omninames

%ifarch x86_64
mv %buildroot%python_sitelibdir_noarch/* %buildroot%python_sitelibdir/
%endif

%files
%config(noreplace) %_sysconfdir/omniORB.cfg
%_libdir/libomni*.so.*

%files idl
%_datadir/idl/omniORB

%files docs
%doc doc/*.pdf

%files COS
%_libdir/libCOS*.so.*

%files utils
%_bindir/catior
%_bindir/convertior
%_bindir/genior
%_bindir/omniMapper
%_man1dir/catior*
%_man1dir/convertior*
%_man1dir/genior*

%files names
%config(noreplace) %_sysconfdir/sysconfig/omninames
%_initdir/omninames
%_bindir/omniNames
%_bindir/nameclt
%_man1dir/nameclt*
%attr(755,daemon,daemon) %dir %_logdir/omniORB

%files -n %packagename
%python_sitelibdir/*

%files devel
%_bindir/omniidl*
%_bindir/omnicpp
%_bindir/omkdepend
%_includedir/omniORB4
%_includedir/omniconfig.h
%_includedir/omnithread
%_includedir/omnithread.h
%_libdir/libomni*.so
%_libdir/pkgconfig/omniORB*
%_libdir/pkgconfig/omniDynamic*
%_libdir/pkgconfig/omnithread*
%_libdir/pkgconfig/omniConnectionMgmt*
%_man1dir/omniidl*
%_man1dir/omnicpp*

%files devel-COS
%_includedir/COS
%_libdir/libCOS*.so
%_libdir/pkgconfig/omniCOS*

%files devel-static
%_libdir/libomni*.a

%files devel-static-COS
%_libdir/libCOS*.a

%changelog
