%def_disable debug
%def_enable apps
%def_disable openmp
%def_without unicap
%def_with swig
%def_with python
%def_without xine
%def_without octave
%def_without gstreamer
%def_with ffmpeg
%def_with 1394libs
%def_with v4l
%def_with gtk
%def_with gthread
%def_without carbon
%def_without imageio
%def_without quicktime
%def_with pic
#----------------------------------------------------------------------
%define set_without() %{expand:%%force_without %{1}} %{expand:%%undefine _with_%{1}}

%{?_with_ffmpeg:%set_without gstreamer}
%{?_with_ffmpeg:%set_without quicktime}
%{?_with_xine:%set_without quicktime}
%{?_with_1394libs:%set_without quicktime}
%{?_with_v4l:%set_without quicktime}

%define bname opencv
%define Name OpenCV
%define sover 2.4
Name: lib%bname%sover
Version: 2.4.9.1
Release: alt0.M70P.3
Epoch: 1
Summary: Open Source Computer Vision Library
License: Distributable
Group: System/Libraries
URL: http://opencv.org
# git://code.opencv.org/opencv.git
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %bname-%version.tar
# ALT
Patch10: %{bname}-%{version}-alt-numpy_deprecated_api.patch
# Debian
Patch50: libav10.patch
# FC, GStreamer1 releted patches
Patch100: 0550-bomb-commit-of-gstreamer-videocapture-and-videowrite.patch
Patch101: 0552-eliminated-warnings.patch
Patch102: 0587-Fix-build-with-gstreamer-0.10.28.patch
Patch103: 0865-gstreamer-cleaning-up-resources.patch
Patch104: 0871-allow-for-arbitraty-number-of-sources-and-sinks.patch

BuildPreReq: chrpath libcvmser
BuildRequires: gcc-c++ libjasper-devel libjpeg-devel libtiff-devel
BuildRequires: openexr-devel graphviz libpng-devel libpixman-devel
BuildPreReq: cmake libnumpy-devel eigen3 doxygen zlib-devel
BuildPreReq: libucil-devel libv4l-devel libtbb-devel bzlib-devel
BuildPreReq: pkgconfig(glproto) pkgconfig(dri2proto) pkgconfig(xext)
BuildPreReq: pkgconfig(xdamage) pkgconfig(xxf86vm)
BuildPreReq: libGLU-devel libXau-devel libXdmcp-devel libgtkglext-devel
BuildPreReq: python-module-sphinx-devel python-module-Pygments
BuildPreReq: texlive-latex-base
%{?_enable_openmp:BuildRequires: libgomp-devel}
%{?_with_unicap:BuildRequires: libunicap-devel}
%{?_with_ffmpeg:BuildRequires: libavformat-devel libswscale-devel}
%{?_with_gstreamer:BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel}
%{?_with_gtk:BuildRequires: libgtk+2-devel}
%{?_with_xine:BuildRequires: libxine-devel}
%{?_with_python:BuildRequires: python-devel}
%{?_with_octave:BuildRequires: octave-devel}
%{?_with_swig:BuildRequires: swig}
%{?_with_1394libs:BuildRequires: libdc1394-devel}

%description
%Name means Intel(R) Open Source Computer Vision Library. It is a
collection of C functions and a few C++ classes that implement many
popular Image Processing and Computer Vision algorithms.
%Name provides cross-platform middle-to-high level API that includes
about 300 C functions and a few C++ classes. Also there are constantly
improving Python bindings to %Name.


%package -n lib%bname-devel
Group: Development/C++
Summary: Development files for %name
Requires: %name = %version-%release
Provides: lib%{bname}2.2-devel = %version-%release
Provides: lib%{bname}2-devel = %version-%release
Conflicts: lib%{bname}2.2-devel < %version-%release
Obsoletes: lib%{bname}2.2-devel < %version-%release
Conflicts: lib%bname-devel < %version-%release
Obsoletes: lib%bname-devel < %version-%release
Conflicts: lib%{bname}2-devel < %version-%release
Obsoletes: lib%{bname}2-devel < %version-%release

%description -n lib%bname-devel
%Name means Intel(R) Open Source Computer Vision Library. It is a
collection of C functions and a few C++ classes that implement many
popular Image Processing and Computer Vision algorithms.
%Name provides cross-platform middle-to-high level API that includes
about 300 C functions and a few C++ classes. Also there are constantly
improving Python bindings to %Name.

This package contains header files and documentation needed to develop
applications with %name.


%package doc
Summary: %name documentation
Group: Development/Documentation
BuildArch: noarch

%description doc
%Name means Intel(R) Open Source Computer Vision Library. It is a
collection of C functions and a few C++ classes that implement many
popular Image Processing and Computer Vision algorithms.
%Name provides cross-platform middle-to-high level API that includes
about 300 C functions and a few C++ classes. Also there are constantly
improving Python bindings to %Name.

This package contains API Reference for develop with %name.


%package tests
Group: Video
Summary: %Name tests
Requires: %name = %version-%release

%description tests
%Name means Intel(R) Open Source Computer Vision Library. It is a
collection of C functions and a few C++ classes that implement many
popular Image Processing and Computer Vision algorithms.
%Name provides cross-platform middle-to-high level API that includes
about 300 C functions and a few C++ classes. Also there are constantly
improving Python bindings to %Name.

This package contains %Name tests applications.

%package utils
Group: Video
Summary: %Name utils
Provides: lib%bname-utils = %version-%release
Conflicts: lib%bname-utils < %version-%release
Obsoletes: lib%bname-utils < %version-%release
Provides: lib%{bname}2-utils = %version-%release
Conflicts: lib%{bname}2-utils < %version-%release
Obsoletes: lib%{bname}2-utils < %version-%release

%description utils
%Name means Intel(R) Open Source Computer Vision Library. It is a
collection of C functions and a few C++ classes that implement many
popular Image Processing and Computer Vision algorithms.
%Name provides cross-platform middle-to-high level API that includes
about 300 C functions and a few C++ classes. Also there are constantly
improving Python bindings to %Name.

This package contains %Name demo applications.


%package -n python-module-%bname%sover
Group: Development/Python
Summary: Python modules for %Name
Provides: python-module-%bname = %version-%release
Conflicts: python-module-%bname < %version-%release
Obsoletes: python-module-%bname < %version-%release
Provides: python-module-%{bname}2 = %version-%release
Conflicts: python-module-%{bname}2 < %version-%release
Obsoletes: python-module-%{bname}2 < %version-%release
Conflicts: python-module-%{bname}2.3
Obsoletes: python-module-%{bname}2.3
Provides: python%{__python_version}(%bname)

%description -n python-module-%bname%sover
%Name means Intel(R) Open Source Computer Vision Library. It is a
collection of C functions and a few C++ classes that implement many
popular Image Processing and Computer Vision algorithms.
%Name provides cross-platform middle-to-high level API that includes
about 300 C functions and a few C++ classes. Also there are constantly
improving Python bindings to %Name.

This package contains an extension module for python that provides a
Python language mapping for the %Name.

%package examples
Group: Video
Summary: %Name samples
BuildArch: noarch
Conflicts: lib%bname-examples
Conflicts: lib%{bname}2-examples

%description examples
%Name means Intel(R) Open Source Computer Vision Library. It is a
collection of C functions and a few C++ classes that implement many
popular Image Processing and Computer Vision algorithms.
%Name provides cross-platform middle-to-high level API that includes
about 300 C functions and a few C++ classes. Also there are constantly
improving Python bindings to %Name.

This package contains %Name examples.

%prep
%setup
%patch10 -p1
%patch50 -p1
%patch100 -p1
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1

rm -fR 3rdparty/{ffmpeg,lib,libjasper,libjpeg,libpng,libtiff,openexr,tbb,zlib}

%prepare_sphinx .
cp -f doc/conf.py ./
cp doc/opencv-logo2.png ./

%build
cmake \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
	-DBUILD_PACKAGE:BOOL=ON \
	-DBUILD_TESTS:BOOL=OFF \
	-DBUILD_EXAMPLES:BOOL=ON \
	-DINSTALL_C_EXAMPLES:BOOL=ON \
	-DINSTALL_PYTHON_EXAMPLES:BOOL=ON \
	-DENABLE_OPENMP:BOOL=OFF \
	-DWITH_TBB:BOOL=ON \
	-DBUILD_PYTHON_SUPPORT:BOOL=ON \
	-DCMAKE_VERBOSE:BOOL=ON \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DCMAKE_CXX_FLAGS:STRING="%optflags" \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
	-DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo \
	-DPYTHON_PLUGIN_INSTALL_PATH:PATH=%python_sitelibdir/%bname \
	-DWITH_UNICAP:BOOL=ON \
	-DWITH_QUICKTIME:BOOL=ON \
	-DWITH_XINE:BOOL=%{?_with_xine:ON}%{!?_with_xine:OFF} \
	-DWITH_FFMPEG:BOOL=%{?_with_ffmpeg:ON}%{!?_with_ffmpeg:OFF} \
	-DWITH_GSTREAMER=%{?_with_gstreamer:ON}%{!?_with_gstreamer:OFF} \
	-DWITH_OPENGL:BOOL=ON \
	-DINSTALL_PYTHON_EXAMPLES:BOOL=ON \
	-DCMAKE_SKIP_RPATH:BOOL=ON \
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
	-DBUILD_opencv_ts:BOOL=OFF \
%ifarch x86_64
	-DLIB_SUFFIX:STRING=64 \
%endif
	.
%make_build VERBOSE=1

%install
%makeinstall_std

install -d %buildroot%_docdir/%name
mv %buildroot%_datadir/%Name/doc/* %buildroot%_docdir/%name/

cp -fR samples/python* %buildroot%_datadir/%Name/samples/

sed -i \
	's|\(Libs:\)\(.*\)|\1 ${exec_prefix}/%_lib/libopencv_legacy.so \2|' \
	%buildroot%_pkgconfigdir/opencv.pc

%files
%doc README.md
%_libdir/*.so.*
# %dir %_datadir/%bname
%dir %_datadir/%Name
%_datadir/%Name/haarcascades
%_datadir/%Name/lbpcascades

%files -n lib%bname-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_datadir/%Name/*.cmake

%files doc
%doc doc/vidsurv
%_docdir/%name

%files utils
%_bindir/*

%files -n python-module-%bname%sover
%python_sitelibdir/*

%files examples
# %dir %_datadir/%bname
%dir %_datadir/%Name
%_datadir/*/samples

%changelog
