%define origname openmotif

Name: libopenmotif3
Version: 2.2.4
Release: alt3

Summary: The Open Motif
License: Open Group Public License
Group: System/Libraries

Url: http://www.motifzone.org
Source: %origname-%version.tar.gz
Packager: Michael Shigorin <mike@altlinux.org>

# RH
Patch1: openMotif-2.2.3-rh-acinclude.patch
Patch2: openMotif-2.2.3-rh-char_not_supported.patch
Patch3: openMotif-2.2.3-rh-libdir.patch
Patch4: openMotif-2.2.3-rh-long64.patch
Patch5: openMotif-2.2.3-rh-multiscreen.patch
Patch6: openMotif-2.2.3-rh-pixel_length.patch
Patch7: openMotif-2.2.3-rh-popup_timeout.patch
Patch8: openMotif-2.2.3-rh-uil_lib.patch
Patch9: openmotif-2.2.3-rh-utf8.patch
Patch10: openMotif-2.2.3-rh-vizcount.patch
# CAN, CVE
Patch21: openMotif-2.2.3-CAN-2004-0687-0688.patch
Patch22: openMotif-2.2.3-CAN-2004-0914.patch
Patch23: openmotif-2.2.3-CAN-2004-0914_sec8.patch
Patch24: openmotif-CVE-2005-3964.patch
#
Patch31: openMotif-2.2.3-motifzone_1193.patch
Patch32: openMotif-2.2.3-motifzone_1202.patch
Patch33: openMotif-2.2.3-rgbtxt.patch
Patch34: openmotif-2.2.3-gentoo-buffer.patch
# ALT
Patch41: openmotif-2.2.2-alt-DefaultUserPath.patch
Patch42: openmotif-2.2.2-alt-VARDIR.patch
Patch43: openmotif-2.2.2-alt-bison.patch
Patch44: openmotif-2.2.3-alt-VERSION.patch
Patch45: openMotif-2.2.4-alt-compatonly.patch
Patch46: openmotif-2.2.x-alt-types.patch

Provides: motif = %version-%release
Provides: openmotif = %version-%release

# Automatically added by buildreq on Sat Mar 24 2012
# optimized out: libICE-devel libSM-devel libX11-devel libXau-devel libXmu-devel libXt-devel libstdc++-devel xorg-printproto-devel xorg-xextproto-devel xorg-xproto-devel
BuildRequires: chrpath flex gcc-c++ imake libXaw-devel libXext-devel libXp-devel xorg-bitmaps xorg-cf-files
BuildRequires: libjpeg-devel libpng-devel

%description
This package contains shared Open Motif 2.2 libraries
required to run legacy Motif 2.2 applications.

%prep
%setup -n %origname-%version
# RH
#patch1 -p1
#patch2 -p1
%patch3 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
#patch9 -p1
%patch10 -p1
# CAN
#patch21 -p1
#patch22 -p1
#patch23 -p1
%patch24 -p1
#
%patch31 -p1
%patch32 -p1
%patch33 -p1
%patch34 -p1
# ALT
%patch41 -p1
%patch42 -p1
#patch43 -p1
%patch44 -p1
%patch45 -p1
%patch46 -p1

#patch4 -p1

find -type f -name \*.orig -print -delete

%build
%set_autoconf_version 2.5
%set_automake_version 1.7
%set_libtool_version 1.5

for i in config.guess config.sub; do ln -sf %_datadir/libtool/config/$i; done
for i in depcomp install-sh missing; do ln -sf %_datadir/automake/$i; done

%add_optflags -D_FILE_OFFSET_BITS=64
export lt_cv_prog_cc_static_works=no
libtoolize --copy --force

CFLAGS="%optflags" \
%configure --enable-shared --disable-static

make clean
%make_build

%install
%makeinstall_std
chrpath -d %buildroot%_libdir/*.so.*

%files
%_libdir/*.so.*
%doc COPYRIGHT.MOTIF RELNOTES

%changelog
