Name: libopenr2
Version: 1.3.1
Release: alt2
Summary: MFC/R2 call setup library

Group: System/Kernel and hardware
License: LGPL
Url: http://www.libopenr2.org/
Source: %name-%version.tar

# Automatically added by buildreq on Thu Sep 17 2009
BuildRequires: dahdi-linux-headers gcc-c++

%description
OpenR2 is a library that implements the MFC/R2 signalling over E1 lines using
the Zapata Telephony interface. The MF R2 tones required for the signaling are
generated by code borrowed from the LGPL library SpanDSP written by Steve Underwood,
the user has the option to provide a MF interface to use his own MF R2 tone generation
and detection so the library will use them when needed, that's why this library does not
depend directly on spandsp, libteletone or zaptel for tone generation and detection
(depends on zaptel for ABCD bits and general media transmission though)

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup 
sed -i 's/-Werror//' src/Makefile.am src/Makefile.in

%build
%configure --libdir=%_libdir --sysconfdir=%_sysconfdir/openr2 --disable-static --disable-rpath
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS ChangeLog COPYING COPYING.LESSER NEWS README TODO
%doc doc/*.alaw
%doc doc/README.asterisk
%doc %dir doc/asterisk
%_bindir/r2test
%_bindir/r2dtmf_detect
%_libdir/*.so.*
%_man5dir/r2test.conf.5.gz
%_man8dir/r2test.8.gz
%dir %_sysconfdir/openr2/
%config(noreplace) %_sysconfdir/openr2/r2test.conf
%config(noreplace) %_sysconfdir/openr2/r2proto.conf

%files devel
%doc AUTHORS ChangeLog COPYING COPYING.LESSER NEWS README TODO
%_includedir/openr2.h
%dir %_includedir/openr2
%_includedir/openr2/*.h
%_libdir/*.so

%changelog
