Name: libopensync0
Version: 0.22
Release: alt4.2.qa1

Summary: A Platform and Distribution Independent Synchronization Framework
License: %lgpl2plus
Group: System/Libraries
URL: http://www.opensync.org/
Packager: Mobile Development Team <mobile@packages.altlinux.org>

Source: libopensync-%version.tar.bz2
Patch71: opensync_user.c.diff
Patch72: libopensync-fix-vcal-reminder.diff
Patch73: libopensync-vformat-infinite-loop.diff
Patch74: alt-libopensync-linkage_fix.diff
Patch75: alt-libopensync-python-lib-check-lib64.patch
Patch76: libopensync-wrapper-err.patch
Patch77: libopensync0-0.22-alt-no-Werror.patch

# Automatically added by buildreq on Thu Oct 16 2008
BuildRequires: gcc-c++ glib2-devel libsqlite3-devel libxml2-devel python-devel swig
BuildRequires: rpm-build-licenses

%description
OpenSync is a synchronization framework that is platform and
distribution independent. It consists of several plug-ins that can be
used to connect to devices, a powerful sync engine, and the framework
itself. The synchronization framework is kept very flexible and is
capable of synchronizing any type of data, including contacts,
calendar, tasks, notes, and files.

%package devel
Summary: Header files, libraries and development documentation for %name
Group: Development/C
Conflicts: libopensync-devel
Requires: %name = %version

%description devel
This package contains the header files, static libraries and development
documentation for %name. If you like to develop programs using %name,
you will need to install %name-devel.

%package tools
Summary: Tools for %name
Group: Development/Other
Requires: %name
Conflicts: libopensync-tools

%description tools
Tools to test and debug %name.

%package -n python-module-opensync0
Summary: Python module for %name.
Group: Development/Python
Requires: %name
Conflicts: python-module-opensync

%description -n python-module-opensync0
Python module for %name.

%prep
%setup -q -n libopensync-%version
%patch71 -p1
%patch72 -p0
%patch73 -p0
%patch74 -p1
%patch75 -p1
%patch76 -p0
%patch77 -p2

%build
# echo > acinclude.m4
%autoreconf
CFLAGS="-fno-strict-aliasing -I%_includedir/python%_python_version" %configure --disable-profiling --enable-tools --disable-unit-tests --enable-python
%make_build

%install
%make_install install DESTDIR=%buildroot
rm -f %buildroot%_libdir/*.la
rm -f %buildroot%_libdir/opensync/formats/*.la
rm -f %buildroot%python_sitelibdir/*.la
mkdir -p %buildroot%_datadir/opensync/defaults

%files
%_libdir/*.so.*
%_libdir/opensync
%_libexecdir/osplugin
%_datadir/opensync/defaults

%files devel
%_includedir/opensync-1.0
%_pkgconfigdir/*.pc
%_libdir/*.so

%files tools
%_bindir/*

%files -n python-module-opensync0
%dir %python_sitelibdir/*

%changelog
