%define _name p11-kit
%define _libexecdir %_prefix/libexec

%def_enable trust_module
# the hash implementation -- freebl or internal
%define hash_impl freebl
%define trust_paths %_datadir/ca-certificates/ca-bundle.crt
#%%define trust_paths %_sysconfdir/pki/ca-trust/source:%_datadir/pki/ca-trust-source

Name: lib%_name
Version: 0.18.5
Release: alt1

Summary: Library for loading and sharing PKCS#11 modules
Group: System/Libraries
License: BSD
Url: http://p11-glue.freedesktop.org/p11-kit.html

Source: http://p11-glue.freedesktop.org/releases/%_name-%version.tar.gz
Source1: p11-kit-extract-trust
Patch: %name-0.16.3-alt-lfs.patch

Requires: ca-certificates
Requires: pkcs11-trust-module = %version-%release

BuildRequires: libtasn1-devel
%if %hash_impl == freebl
BuildRequires: libnss-devel
%endif

%description
%_name provides a way to load and enumerate PKCS#11 modules, as well
as a standard configuration setup for installing PKCS#11 modules in
such a way that they're discoverable.

%package        trust
Summary: System trust module from %name package
Group: System/Libraries
Requires: %name = %version-%release
Provides: pkcs11-trust-module = %version-%release
#Conflicts: libnss < 3.14.3

%description    trust
The %name-trust package contains a system trust PKCS#11 module which
contains certificate anchors and black lists.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
%_name provides a way to load and enumerate PKCS#11 modules, as well
as a standard configuration setup for installing PKCS#11 modules in
such a way that they're discoverable.

The %name-devel package provides libraries and headers for developing
applications that use %_name library.

%package devel-doc
Summary: Development documentation for %_name
Group: Development/C
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
%_name provides a way to load and enumerate PKCS#11 modules, as well
as a standard configuration setup for installing PKCS#11 modules in
such a way that they're discoverable.

This package contains development documentation for %_name library.

%prep
%setup -n %_name-%version
%patch

%build
%autoreconf
%configure --disable-static \
	%{subst_enable trust_module} \
%if_enabled trust_module
	--with-libtasn1 \
	--with-trust-paths=%trust_paths \
%endif
	--with-hash-impl=%hash_impl \

%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_sysconfdir/pkcs11/modules
install -p -m755 %SOURCE1 %buildroot/%_libdir/%_name/

# alternatives
mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_libdir/libnssckbi.so	%_libdir/pkcs11/p11-kit-trust.so 30
EOF

%check
%make check

%files
%_bindir/%_name
%_libdir/lib%_name.so.*
%_libdir/%_name-proxy.so
%dir %_libdir/%_name
%dir %_datadir/%_name
%dir %_datadir/%_name/modules
%dir %_sysconfdir/pkcs11
%dir %_sysconfdir/pkcs11/modules
%doc AUTHORS COPYING NEWS README
%doc p11-kit/pkcs11.conf.example
%exclude %_sysconfdir/pkcs11/pkcs11.conf.example

%if_enabled trust_module
%files trust
%_libdir/pkcs11/%_name-trust.so
%_datadir/%_name/modules/%_name-trust.module
%_libdir/%_name/p11-kit-extract-trust
#%_altdir/%name
%exclude %_libdir/pkcs11/p11-kit-trust.la
%endif

%files devel
%_includedir/%_name-1
%_libdir/lib%_name.so
%_libdir/pkgconfig/%_name-1.pc

%files devel-doc
%_datadir/gtk-doc/html/%_name

%changelog
