%define _name pango
%define ver_major 1.34
%define module_ver 1.8.0
%def_disable static
%def_disable gtk_doc
%def_enable introspection

Name: lib%_name
Version: %ver_major.1
Release: alt1

Summary: System for layout and rendering of internationalized text
License: %lgpl2plus
Group: System/Libraries
Url: http://www.pango.org/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.xz

Source10: pango-compat.map
Source11: pango-compat.lds
Source12: pangoft2-compat.map
Source13: pangoft2-compat.lds
Source14: pangocairo-compat.map
Source15: pangocairo-compat.lds

Patch: pango-1.32.2-alt-compat-version-script.patch
# check.defs always true
Patch3: pango-1.30.0-alt-check_defs.patch

Provides: %_name = %version
Obsoletes: %_name < %version
Obsoletes: gscript

# From configure.in
%define glib_ver 2.33.12
%define cairo_ver 1.7.6
%define gtk_doc_ver 1.0
%define xft_ver 2.0.0
%define fontconfig_ver 2.10.91
%define freetype_ver 2.1.4
%define gi_ver 0.9.5
%define hb_ver 0.9.11

# We need to prereq these so we can run pango-querymodules in post
PreReq: glib2 >= %glib_ver
PreReq: libXft

BuildPreReq: rpm-build-gnome rpm-build-licenses gnome-common gtk-doc
BuildPreReq: fontconfig-devel >= %fontconfig_ver
BuildPreReq: libfreetype-devel >= %freetype_ver
BuildPreReq: libXft-devel >= %xft_ver 
BuildPreReq: libcairo-devel >= %cairo_ver libcairo-gobject-devel
BuildPreReq: glib2-devel >= %glib_ver libgio-devel
BuildPreReq: libharfbuzz-devel >= %hb_ver
BuildPreReq: gtk-doc >= %gtk_doc_ver
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= %gi_ver}
BuildPreReq: gcc-c++ help2man

%description
A library to handle unicode strings as well as complex bidirectional
or context dependent shaped strings.

%package devel
Summary: Development libraries and header files for pango
Group: Development/C
Provides: %_name-devel = %version
Obsoletes: %_name-devel < %version
Requires: %name = %version-%release

%description devel
The pango-devel package includes the libraries and header files
for the pango package.

%package devel-doc
Summary: Development documentation for Pango
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
Pango is a library to handle unicode strings as well as complex
bidirectional or context dependent shaped strings.

This package contains development documentation for Pango.

%if_enabled static
%package devel-static
Summary: Static libraries for pango
Group: Development/C

%description devel-static
The pango-devel package includes the static libraries for the pango package.
%endif

%package gir
Summary: GObject introspection data for the Pango library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Pango library

%package gir-devel
Summary: GObject introspection devel data for the Pango library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Pango library

%prep
%setup -q -n %_name-%version
%patch -p1
install -p -m644 %_sourcedir/pango{,ft2,cairo}-compat.{map,lds} pango/
%patch3



%build
%add_optflags -fno-strict-aliasing
%autoreconf
%configure \
    %{subst_enable static} \
    %{subst_enable introspection} \
    --enable-man \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    --disable-dependency-tracking \
    --enable-explicit-deps=yes

%make_build

%check
%make check

%install
%makeinstall_std
ln %buildroot%_bindir/%_name-querymodules %buildroot%_libdir/%_name/
touch %buildroot%_libdir/%_name/%module_ver/modules.cache
mkdir -p %buildroot%_sysconfdir/%_name

%post
%_libdir/%_name/%_name-querymodules --system --update-cache

%files
%_bindir/%_name-querymodules
%_bindir/%_name-view
%dir %_libdir/%_name
%dir %_libdir/%_name/%module_ver
%dir %_libdir/%_name/%module_ver/modules
%_libdir/%name-1.0.so.*
%_libdir/%{name}cairo-1.0.so.*
%_libdir/%{name}ft2-1.0.so.*
%_libdir/%{name}xft-1.0.so.*
%_libdir/%_name/%module_ver/*/*.so
%_libdir/%_name/%_name-querymodules
%ghost %_libdir/%_name/%module_ver/modules.cache
%_man1dir/%_name-querymodules.*
%_man1dir/%_name-view.*
%dir %_sysconfdir/%_name
%doc AUTHORS NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled introspection
%files gir
%_typelibdir/*

%files gir-devel
%_girdir/*
%endif

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files devel-static
%_libdir/*.a
%_libdir/%_name/%module_ver/*/*.a
%endif

%exclude %_libdir/%_name/%module_ver/modules/*.la

%changelog
