Name: libpcap
Version: 1.1.1
Release: alt3
Epoch: 2

Summary: A system-independent interface for user-level packet capture
License: BSD
Group: System/Libraries
Url: http://www.tcpdump.org

# git://git.altlinux.org/gears/l/libpcap
Source: %name-%version-%release.tar

%define libname libpcap0.8
%def_disable static

BuildRequires: flex
# bluetooth sniffing support
BuildRequires: libbluez-devel

%package -n %libname
Summary: A system-independent interface for user-level packet capture
Group: System/Libraries
Provides: %name = %epoch:%version-%release
Obsoletes: %name

%package devel
Summary: Development environment for the packet capture library
Group: Development/C
Requires: %libname = %epoch:%version-%release

%package devel-static
Summary: Static packet capture library
Group: Development/C
Requires: %name-devel = %epoch:%version-%release

%description
Libpcap provides a portable framework for low-level network monitoring.
Libpcap can provide network statistics collection, security monitoring
and network debugging.  Since almost every system vendor provides a
different interface for packet capture, the libpcap authors created this
system-independent API to ease in porting and to alleviate the need for
several system-dependent packet capture modules in each application.

%description -n %libname
Libpcap provides a portable framework for low-level network monitoring.
Libpcap can provide network statistics collection, security monitoring
and network debugging.  Since almost every system vendor provides a
different interface for packet capture, the libpcap authors created this
system-independent API to ease in porting and to alleviate the need for
several system-dependent packet capture modules in each application.

%description devel
Libpcap provides a portable framework for low-level network monitoring.
Libpcap can provide network statistics collection, security monitoring
and network debugging.  Since almost every system vendor provides a
different interface for packet capture, the libpcap authors created this
system-independent API to ease in porting and to alleviate the need for
several system-dependent packet capture modules in each application.

This package contains development files needed to develop libpcap-based
applications such as tcpdump, etc.

%description devel-static
Libpcap provides a portable framework for low-level network monitoring.
Libpcap can provide network statistics collection, security monitoring
and network debugging.  Since almost every system vendor provides a
different interface for packet capture, the libpcap authors created this
system-independent API to ease in porting and to alleviate the need for
several system-dependent packet capture modules in each application.

This package contains the static pcap library needed to develop
statically linked libpcap-based applications.

%prep
%setup -n %name-%version-%release
echo %version > VERSION
bzip2 -9k CHANGES

%build
%configure
%make_build shared pcap-config

%install
%make_install DESTDIR=%buildroot \
	install-shared %{?_enable_shared:install-archive} \
	install-include install-bin install-man

%define _customdocdir %_docdir/libpcap-%version

%files -n %libname
%_libdir/*.so.*
%_man7dir/*
%doc CHANGES.bz2 CREDITS LICENSE README README.linux TODO

%files devel
%_bindir/*
%_libdir/*.so
%_includedir/*
%_mandir/man[135]/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif #static

%changelog
