#
# spec file for package libpff
#
# Copyright (c) 2013 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

Name: libpff
Version: 20131028
Release: alt0.M70T.1

Summary: Library and tools to access Microsoft PFF and OFF format files
License: LGPLv3+ and GFDLv1.1+ and GFDLv1.3+
Group: File tools

Url: http://code.google.com/p/libpff/
#DL-URL:        https://googledrive.com/host/0B3fBvzttpiiScU9qcG5ScEZKZE0/libpff-experimental-20130722.tar.gz
Source0: %name-experimental-%version.tar.gz
Source1: %name.watch
Source2: PFF_Forensics_-_analyzing_the_horrible_reference_file_format.pdf
Source3: PFF_forensics_-_e-mail_and_appoinment_falsification_analysis.pdf
Source4: Personal_Folder_File_(PFF)_format.pdf
Source5: MAPI_definitions.pdf
Source6: libpff-libfdata.pdf
Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires: pkg-config
BuildRequires: python-dev
BuildRequires: pkgconfig(libcsplit) >= 20130609
BuildRequires: pkgconfig(libcfile) >= 20130609
BuildRequires: pkgconfig(libcpath) >= 20130609
BuildRequires: pkgconfig(libclocale) >= 20130609
BuildRequires: pkgconfig(libbfio) >= 20130721
# fails to build with factory package, use internal
# verified 7/31/2013
#BuildRequires:  pkgconfig(libcerror) >= 20120425
#BuildRequires:  pkgconfig(libcnotify) >= 20120425
#BuildRequires:  pkgconfig(libfguid) >= 20120426
#BuildRequires:  pkgconfig(libuna) >= 20120425
#BuildRequires:  pkgconfig(libfdatetime) >= 20120522
# not (yet) released as packages by upstream
#BuildRequires:  pkgconfig(libfmapi) >= 20120405
#BuildRequires:  pkgconfig(libfvalue) >= 20120428
#BuildRequires:  pkgconfig(libfwnt) >= 20120426
#BuildRequires:  pkgconfig(libcstring) >= 20120425
#BuildRequires:  pkgconfig(libcsystem) >= 20120425
#BuildRequires:  pkgconfig(libfcache) >= 20120405
#BuildRequires:  pkgconfig(libfdata) >= 20120405

%description
libpff is a library to access the Personal Folder File (PFF) and the
Offline Folder File (OFF) format. These are used in several file
Types: PAB (Personal Address Book), PST (Personal Storage Table) and
OST (Offline Storage Table).

%package tools
Summary: Tools to access Microsoft PST and OST files
License: LGPLv3+
Group: File tools
Requires: %name = %version

%description tools
Tools to access the Personal Folder File (PFF) and the Offline Folder
File (OFF) format. These are used in several file types: PAB
(Personal Address Book), PST (Personal Storage Table) and OST
(Offline Storage Table).

%package devel
Summary: Development files for libpff, a PFF/OFF file format library
License: LGPLv3+ and GFDL-1.1+ and GFDLv1.3+
Group: Development/C
Requires: %name = %version

%description devel
libpff is a library to access the Personal Folder File (PFF) and the
Offline Folder File (OFF) format. These are used in several file
Types: PAB (Personal Address Book), PST (Personal Storage Table) and
OST (Offline Storage Table).

This subpackage contains libraries and header files for developing
applications that want to make use of libpff.

%package -n python-module-%name
Summary: Python bindings for libpff, a PFF/OFF file format parser
License: LGPLv3+
Group: Development/Python
Requires: python-base

%description -n python-module-%name
Python bindings for libpff, which can read Personal Folder File (PFF)
and Offline Folder File (OFF) formats.

%prep
%setup
cp -a "%{S:2}" "%{S:3}" "%{S:4}" "%{S:5}" "%{S:6}" .

%build
%configure \
	--disable-static \
	--enable-wide-character-type \
	--enable-python
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS ChangeLog
%_libdir/*.so.*

%files tools
%doc AUTHORS ChangeLog
%_bindir/*
%_man1dir/*

%files devel
%doc AUTHORS README ChangeLog
%doc MAPI_definitions.pdf
%doc PFF_Forensics_-_analyzing_the_horrible_reference_file_format.pdf
%doc PFF_forensics_-_e-mail_and_appoinment_falsification_analysis.pdf
%doc Personal_Folder_File_*.pdf
%_includedir/*
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man3dir/*

%files -n python-module-%name
%python_sitelibdir/pypff.so

%changelog
