# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: gcc-c++ unzip
# END SourceDeps(oneline)
%add_optflags %optflags_shared
%define oldname polyclipping
# The Clipper C++ crystallographic library already uses the name "clipper".
# The developer is fine with the choosen name.

# API monitoring
# http://upstream-tracker.org/versions/clipper.html

Name:           libpolyclipping
Version:        6.1.3a
Release:        alt0.M70P.1_2
Summary:        Polygon clipping library

Group:          System/Libraries
License:        Boost
URL:            http://sourceforge.net/projects/polyclipping
Source0:        http://downloads.sourceforge.net/%{oldname}/clipper_ver%{version}.zip

BuildRequires: ctest cmake
BuildRequires:  dos2unix
Source44: import.info
Provides: polyclipping = %{version}-%{release}

%description
This library primarily performs the boolean clipping operations -
intersection, union, difference & xor - on 2D polygons. It also performs
polygon offsetting. The library handles complex (self-intersecting) polygons,
polygons with holes and polygons with overlapping co-linear edges.
Input polygons for clipping can use EvenOdd, NonZero, Positive and Negative
filling modes. The clipping code is based on the Vatti clipping algorithm,
and outperforms other clipping libraries.

%package        devel
Summary:        Development files for %{oldname}
Group:          Development/C
Requires:       %{name}%{?_isa} = %{version}-%{release}
Provides: polyclipping-devel = %{version}-%{release}

%description    devel
The %{oldname}-devel package contains libraries and header files for
developing applications that use %{oldname}.


%prep
%setup -n %{oldname}-%{version} -qc

# Delete binaries
find . \( -name "*.exe" -o -name "*.dll" \) -delete

# Correct line ends and encodings
find . -type f -exec dos2unix -k {} \;

for filename in perl/perl_readme.txt README; do
  iconv -f iso8859-1 -t utf-8 "${filename}" > "${filename}".conv && \
    touch -r "${filename}" "${filename}".conv && \
    mv "${filename}".conv "${filename}"
done

# Enable use_lines
sed -i 's|^//#define use_lines$|#define use_lines|' cpp/clipper.hpp

%build
pushd cpp
  %{fedora_cmake}
  make %{?_smp_mflags}
popd


%install
pushd cpp
  make install DESTDIR=%{buildroot}

# Install agg header with corrected include statement
  sed -e 's/\.\.\/clipper\.hpp/clipper.hpp/' < cpp_agg/agg_conv_clipper.h > %{buildroot}/%{_includedir}/%{oldname}/agg_conv_clipper.h
popd

sed -i -e 's,Version:.*,Version: %version,' %{buildroot}%{_datadir}/pkgconfig/%{oldname}.pc

%files
%doc License.txt README
%doc Haskell perl ruby python Documentation
%{_libdir}/lib%{oldname}.so.*

%files devel
%{_datadir}/pkgconfig/%{oldname}.pc
%{_includedir}/%{oldname}/
%{_libdir}/lib%{oldname}.so

%changelog
