%define oname	projectM

Name: lib%oname
Version: 2.1.0
Release: alt8.M70P.1

License: LGPLv2.1
Group: System/Libraries
Url: http://projectm.sourceforge.net/

Summary: Awesome music visualizer

Packager: Motsyo Gennadi <drool@altlinux.ru>

Source0: http://freefr.dl.sourceforge.net/project/projectm/2.0.1/%oname-complete-%version-Source.tar.gz
Patch1: %name-complete-2.1.0-doxy.patch
Patch2: %name-complete-2.1.0-link.patch

Requires: fonts-ttf-dejavu

BuildPreReq: doxygen

BuildRequires: cmake gcc-c++ libXScrnSaver-devel libXcomposite-devel libXcursor-devel libXft-devel libXinerama-devel
BuildRequires: libXpm-devel libXrandr-devel libXtst-devel libXv-devel libXxf86misc-devel libftgl-devel libglew-devel
BuildRequires: libgomp-devel libxkbfile-devel xorg-xf86vidmodeproto-devel libvisual0.4-devel libqt4-devel libpulseaudio-devel >= 0.9.8
BuildRequires: libSDL-devel

%description
projectM is a reimplementation of Milkdrop under OpenGL. It is an
awesome music visualizer. There is nothing better in the world of
Unix.

%package qt
Summary: The Qt frontend to the projectM visualization plugin
Group: System/Libraries
Requires: %name = %version-%release

%description qt
projectM-qt is a GUI designed to enhance the projectM user and preset writer
experience. It provides a way to browse, search, rate presets and setup
preset playlists for projectM-jack and projectM-pulseaudio.

%package -n %oname-pulseaudio
Summary: The projectM visualization plugin for pulseaudio
Group: Sound
Requires: %name-qt = %version-%release

%description -n %oname-pulseaudio
This package allows the use of the projectM visualization plugin through any
pulseaudio compatible applications.

%package -n %oname-test
Summary: Test utils for projectM
Group: Other
License: GPLv2
Requires: %name = %version-%release

%description -n %oname-test
Test utils for projectM

%package -n %oname-libvisual
Summary: The projectM visualization plugin for libvisual
Group: Sound
License: GPLv2
Requires: %name = %version-%release

%description -n %oname-libvisual
This package allows the use of the projectM visualization plugin through any
libvisual compatible applications.

%package devel
Summary: Header files for projectM library
Group: Development/C
Requires: %name = %version-%release
Requires: %name-qt = %version-%release

%description devel
Header files for projectM library.

%package static
Summary: Static projectM library
Group: Development/Libraries
Requires: %name-devel = %version-%release

%description static
Static projectM library.

%prep
%setup -n %oname-complete-%version-Source
%patch1 -p1
%patch2 -p1

%build
cmake \
	-DCMAKE_INSTALL_PREFIX=%prefix \
	-DCMAKE_CXX_FLAGS:STRING="%optflags" \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
	-DUSE_FBO:STRING=FALSE \
	-DLIB_INSTALL_DIR:STRING=%_libdir \
%ifarch x86_64
	-DLIB_SUFFIX=64 \
%endif

%make_build
cd docs && doxygen %oname.dox

%install
%make DESTDIR=%buildroot install

%ifarch x86_64
mv %buildroot%_prefix/lib/* %buildroot%_libdir/
%endif

rm -f %buildroot/%_libdir/libprojectM.a
rm -f %buildroot/%_datadir/%oname/fonts/*.ttf
ln -s /usr/share/fonts/ttf/dejavu/DejaVuSans.ttf %buildroot/%_datadir/%oname/fonts/Vera.ttf
ln -s /usr/share/fonts/ttf/dejavu/DejaVuSansMono.ttf %buildroot/%_datadir/%oname/fonts/VeraMono.ttf

%files
%doc AUTHORS.txt FAQ.txt docs/doxygen/html
%_libdir/libprojectM.so.*
%dir %_datadir/%oname/
%_datadir/%oname/config.inp
%dir %_datadir/%oname/fonts/
%_datadir/%oname/fonts/*.ttf
%dir %_datadir/%oname/presets/
%_datadir/%oname/presets/*
%dir %_datadir/%oname/shaders/
%_datadir/%oname/shaders/*

%files qt
%_libdir/libprojectM-qt.so.*

%files -n %oname-pulseaudio
%_bindir/*-pulseaudio
%_desktopdir/*-pulseaudio.desktop
%_pixmapsdir/prjm16-transparent.svg

%files -n %oname-test
%_bindir/*-test*

%files -n %oname-libvisual
%doc src/projectM-libvisual/AUTHORS src/projectM-libvisual/ChangeLog
%_libdir/libvisual*/actor/libprojectM_libvisual.so

%files devel
%_includedir/%name/
%_includedir/%name-qt/
%_libdir/libprojectM.so
%_libdir/libprojectM-qt.so
%_pkgconfigdir/libprojectM.pc
%_pkgconfigdir/libprojectM-qt.pc

#%files static
#%_libdir/libprojectM.a

%changelog
