%def_without gnome
%def_with gnome3
%def_with kde4
%def_with networkmanager
%def_with mozjs
%def_without webkit
%def_with webkit3
%def_without dotnet
%def_with python
%define _libexecdir %_prefix/libexec

Name: libproxy
Version: 0.4.11
Release: alt1
Summary: A library handling all the details of proxy configuration

Group: System/Libraries
License: %gpllgpl2plus
Url: http://code.google.com/p/libproxy/

Source: http://libproxy.googlecode.com/files/libproxy-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-licenses
BuildPreReq: cmake ctest gcc-c++

%{?_with_python:BuildRequires: python-devel}
# gnome
%{?_with_gnome:BuildRequires: glib2-devel libGConf-devel}
# gnome3
%{?_with_gnome3:BuildRequires: glib2-devel libgio-devel >= 2.26}
# kde4
%{?_with_kde4:BuildPreReq: libqt4-devel kde4libs-devel kde-common-devel}
# libmozjs
%{?_with_mozjs:BuildRequires: libmozjs-devel >= 1.8.5}
# webkit (gtk)
%{?_with_webkit:BuildRequires: libwebkitgtk2-devel}
%{?_with_webkit3:BuildRequires: libjavascriptcoregtk3-devel}
# NetworkManager
%{?_with_networkmanager:BuildRequires: NetworkManager-devel libdbus-devel}
# dotnet
%{?_with_dotnet:BuildPreReq: mono-devel >= 2.0.0 /proc rpm-build-mono mono-mcs}

%define modilesdir %_libdir/%name/%version/modules/
%description
libproxy offers the following features:

    * extremely small core footprint (< 35K)
    * no external dependencies within libproxy core
      (libproxy plugins may have dependencies)
    * only 3 functions in the stable external API
    * dynamic adjustment to changing network topology
    * a standard way of dealing with proxy settings across all scenarios
    * a sublime sense of joy and accomplishment

%package tools
Summary: A sample & test application to test what libproxy will reply
Group: Networking/Other
Requires: %name = %version-%release

%description tools
A simple application that will use libproxy to give the results you can expect from.
other applications. Great to debug what would happen.

%package -n python-module-%name
Summary: Python bindings for %name
Group: Development/Python
BuildArch: noarch
Requires: %name = %version-%release

%description -n python-module-%name
Allows for the usage of libproxy from python applications

%package gnome
Summary: Libproxy module for gnome configuration
Group: System/Libraries
Requires: %name = %version-%release

%description gnome
A module to extend libproxy with capabilities to query gnome/gconf about the proxy settings

%package gnome3
Summary: Libproxy module for gnome3 configuration
Group: System/Libraries
Requires: %name = %version-%release

%description gnome3
A module to extend libproxy with capabilities to query gnome/gsettings about the proxy settings

%package kde4
Summary: Libproxy module for kde4 configuration
Group: System/Libraries
Requires: %name = %version-%release

%description kde4
A module to extend libproxy with capabilities to query KDE4 about proxy settings

%package mozjs
Summary: Libproxy module to support wpad/pac parsing via Mozilla JavaScript Engine
Group: System/Libraries
Requires: %name = %version-%release

%description mozjs
A module to extend libproxy with capabilities to pass addresses to a WPAD/PAC Script
to have it parse for the correct proxy. PAC requires JavaScript Engine in the back.

%package webkit
Summary: Libproxy module to support webkit
Group: System/Libraries
Requires: %name = %version-%release

%description webkit
The %name-webkit package contains the %name plugin for
WebKit.

%package networkmanager
Summary: Libproxy module for networkmanager configuration
Group: System/Libraries

%description networkmanager
A module to extend libproxy with capabilities to query NetworkManager about proxy settings

%package sharp
Summary:  Mono bindings for %name
Group: Development/Other
Requires: %name = %version-%release

%description sharp
Allows for the usage of libproxy from python applications

%package sharp-devel
Summary:  Mono bindings for %name
Group: Development/Other
Requires: %name-sharp = %version-%release

%description sharp-devel
Development files for %name-sharp-devel

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -q
%patch -p1

%build
%cmake \
	-DLIBEXEC_INSTALL_DIR=%_libexecdir \
	-DMODULE_INSTALL_DIR=%modilesdir \
%if_without gnome
	-DWITH_GNOME2=OFF \
%endif
	-DWITH_WEBKIT3=ON \
	-DWITH_PERL=OFF \


pushd BUILD
%make_build
popd

%install
pushd BUILD
%make_install install DESTDIR=%buildroot
popd

#In case all modules are disabled
mkdir -p %buildroot%modilesdir

%check
pushd BUILD
%make test
popd

%files
%_libdir/*.so.*
%dir %_libdir/%name
%dir %_libdir/%name/%version
%dir %modilesdir

%doc AUTHORS README

%files tools
%_bindir/proxy

%if_with python
%files -n python-module-%name
%python_sitelibdir_noarch/*
%endif

%if_with gnome
%files gnome
%modilesdir/config_gnome.so
%_usr/libexec/pxgconf
%endif

%if_with gnome3
%files gnome3
%modilesdir/config_gnome3.so
%_usr/libexec/pxgsettings
%endif

%if_with kde4
%files kde4
%modilesdir/config_kde4.so
%endif

%if_with mozjs
%files mozjs
%modilesdir/pacrunner_mozjs.so
%endif

%if_with webkit3
%files webkit
%modilesdir/pacrunner_webkit.so
%endif

%if_with networkmanager
%files networkmanager
%modilesdir/network_networkmanager.so
%endif

%if_with dotnet
%files sharp
%_monodir/%name-sharp
%_monogacdir/*
%exclude %_libdir/%name/%version/libproxy-sharp.dll

%files sharp-devel
%_pkgconfigdir/libproxy-sharp-1.0.pc
%endif

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/libproxy-1.0.pc
%_datadir/cmake/Modules/Findlibproxy.cmake

%changelog
