%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl
%define somver 0
%define sover %somver.2.4

Name: libpsblas
Version: 3.0.2
Release: alt1
Summary: Parallel Sparse Basic Linear Algebra Subroutines
License: BSD
Group: System/Libraries
Url: http://www.ce.uniroma2.it/psblas/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar.gz

BuildPreReq: %mpiimpl-devel libblacs-devel liblapack-devel
BuildPreReq: libmetis-devel

%description
Most computationally intensive applications work on irregular and sparse domains
that complicate their implementation on parallel machines. The major goal of the
Parallel Sparse Basic Linear Algebra Subroutines (PSBLAS) project is to provide
a framework to enable easy, efficient and portable implementations of iterative
solvers for linear systems, while shielding the user from most details of their
parallelization. The interface is designed keeping in view a Single Program
Multiple Data programming model on distributed memory machines. 

%package doc
Summary: Documentation for Parallel Sparse Basic Linear Algebra Subroutines
Group: Development/Documentation
BuildArch: noarch

%description doc
Most computationally intensive applications work on irregular and sparse domains
that complicate their implementation on parallel machines. The major goal of the
Parallel Sparse Basic Linear Algebra Subroutines (PSBLAS) project is to provide
a framework to enable easy, efficient and portable implementations of iterative
solvers for linear systems, while shielding the user from most details of their
parallelization. The interface is designed keeping in view a Single Program
Multiple Data programming model on distributed memory machines. 

This package contains development documentation for PSBLAS.

%package devel
Summary: Development files of Parallel Sparse Basic Linear Algebra Subroutines
Group: Development/Other
Requires: %name = %version-%release

%description devel
Most computationally intensive applications work on irregular and sparse domains
that complicate their implementation on parallel machines. The major goal of the
Parallel Sparse Basic Linear Algebra Subroutines (PSBLAS) project is to provide
a framework to enable easy, efficient and portable implementations of iterative
solvers for linear systems, while shielding the user from most details of their
parallelization. The interface is designed keeping in view a Single Program
Multiple Data programming model on distributed memory machines. 

This package contains development files of PSBLAS.

%prep
%setup
sed -i 's|(BUILDROOT)|%buildroot|' Make.inc.in

%build
mpi-selector --set %mpiimpl
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath=%mpidir/lib -L%mpidir/lib"

%add_optflags %optflags_shared -DHAVE_METIS
chmod +x autogen.sh
./autogen.sh

%configure \
	--with-ccopt="%optflags %optflags_shared" \
	--with-fcopt="%optflags %optflags_shared" \
	--with-f90copt="%optflags %optflags_shared" \
	--with-blas="-lopenblas" \
	--with-lapack="-llapack" \
	--with-blacs="-lblacs" \
	--with-metis="-lmetis -lm"
%make_build

%install
%makeinstall_std

mv %buildroot%prefix/Make.inc %buildroot%_includedir/

install -d %buildroot%_docdir/%name
mv %buildroot%prefix/docs/* %buildroot%_docdir/%name/

# shared libraries

source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath=%mpidir/lib -L%mpidir/lib"

pushd %buildroot%_libdir
LIBS="psb_base psb_prec psb_krylov psb_util"
LINKS="-L$PWD"
mkdir tmp
pushd tmp
for i in $LIBS; do
	ar x ../lib$i.a
	mpif90 -shared -Wl,-soname,lib$i.so.%somver * -Wl,-rpath,%mpidir/lib \
		-o ../lib$i.so.%sover $LINKS -lmetis -llapack -lopenblas
	ln -s lib$i.so.%sover ../lib$i.so.%somver
	ln -s lib$i.so.%somver ../lib$i.so
	rm -f *
	export LINKS="$LINKS -l$i"
done
popd
rmdir tmp
popd

sed -i 's|%buildroot||g' %buildroot%_includedir/Make.inc
sed -i 's|^\(INSTALL_DOCSDIR\).*|\1=%_docdir/%name|' \
	%buildroot%_includedir/Make.inc

%files
%doc Changelog LICENSE README
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_includedir/*

%files doc
%_docdir/%name
%doc test

%changelog
