Name: libpst
Version: 0.6.58
Release: alt1

Summary: Tools for conversion of Outlook files to mailbox and other formats
License: %gpl2plus
Group: System/Libraries

Url: http://www.five-ten-sg.com/libpst
Source0: %url/packages/%name-%version.tar.gz
Source100: libpst.watch
Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires(pre): rpm-build-licenses

# Automatically added by buildreq on Tue Aug 04 2009
BuildRequires: ImageMagick-tools boost-python-devel gcc-c++ libgd2-devel
BuildRequires: libgsf-devel

%define pkgdocdir %_docdir/%name-%version

%description
libpst converts Outlook PST files to mailbox and others formats:
kmail, its own recursive format or separate each email into its own
file. It currently handles EMails, Folders and mostly Contacts.

This is a fork of the libpst project at SourceForge. Another fork is
located at http://alioth.debian.org/projects/libpst/

This version can now convert both 32 bit Outlook files (pre 2003), and
the 64 bit Outlook 2003 pst files. Utilities are supplied to convert
email messages to both mbox and MH mailbox formats, and to DII load file
format for use with many of the CT Summation products. Contacts can be
converted to a simple list, to vcard format, or to ldif format for
import to an LDAP server.

%package devel
Summary: Development files for libpst
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides header and libraries for build programs
against libpst

%package tools
Summary: libpst tools
Group: File tools
Requires: %name = %version-%release

%description tools
Tools to cope with PST (Outlook Personal Folders) files:
  readpst - convert to mbox and other formats
  lspst - list PST file data
  readpstlog - convert a readpst logfile to text format
  pst2ldif - extract contacts in .ldif format
  pst2dii - extract email messages into DII load format

%package docs
Summary: libpst documentation
Group: Documentation
Requires: %name = %version-%release
BuildArch: noarch

%description docs
Developer's documentation for libpst

%prep
%setup

%build
%autoreconf
%configure \
	--enable-libpst-shared \
	--disable-static
%make

%install
%makeinstall_std

%files
%_libdir/*.so.*
%dir %pkgdocdir
%pkgdocdir/[A-Z]*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*
%_man5dir/*

%files tools
%_bindir/*
%_man1dir/*

%files docs
%pkgdocdir/*/
%exclude %pkgdocdir/[A-Z]*

%changelog
