%define oname ptlib

Name: libpt
Version: 2.10.10
Release: alt1
Summary: Portable Tools Libary
License: MPL
Group: System/Libraries
Url: http://www.opalvoip.org/

Provides: ptlib libpw
Obsoletes: libpw

Source: %oname-%version.tar
Patch: %oname-%version-%release.patch

BuildRequires: flex gcc-c++ libSDL-devel libalsa-devel libexpat-devel
BuildRequires: libldap-devel libpulseaudio-devel libv4l-devel
BuildRequires: libssl-devel libsasl2-devel

%description
PTLib (Portable Tools Library) is a moderately large class library that has it's
genesis many years ago as PWLib (portable Windows Library), a method to product
applications to run on both Microsoft Windows and Unix systems. It has also been
ported to other systems such as Mac OSX, VxWorks and other embedded systems.

Since then the system has grown to include many classes that assist in writing
complete multi-platform applications. Classes for I/O portability, multi-
threading portability, aid in producing unix daemons and NT services portably
and all sorts of internet protocols were added over the years. So it became a
Portable Tools Library and was renamed to PTLib.

All this over and above basic "container" classes such as arrays, linear lists,
sorted lists (RB Tree) and dictionaries (hash tables) which were all created
before STL was standardized. Future versions of PTLib will see many of these
classes replaced or supplemented by STL.

%package devel
Summary: Portable Tools Libary development files
Group: Development/C
Requires: %name = %version-%release
Provides: libpw-devel
Obsoletes: libpw-devel

%description devel
Header files and libraries for developing applications that use %oname

%package plugins
Summary: Main plugins for %oname
Group: System/Libraries
Requires: %name = %version-%release
Provides: libpw-plugins
Obsoletes: libpw-plugins

%description plugins
This package contains the oss, alsa and v4l2 plugins for ptlib

%prep
%setup -q -n %oname-%version
%patch -p1

cd plugins
autoconf -f
cd ..

%build
%configure \
	--disable-static \
	--enable-v4l2 \
	--enable-plugins \
	--enable-alsa \
	--enable-pulse \
	--disable-oss \
	--disable-avc \
	--disable-v4l
%make_build

%install
%make DESTDIR=%buildroot install

%files
%doc *.txt
%_libdir/lib*.so.*

%files devel
%_bindir/%oname-config
%_includedir/pt*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/%oname

%files plugins
%dir %_libdir/%oname-%version
%dir %_libdir/%oname-%version/devices
%dir %_libdir/%oname-%version/devices/sound
%dir %_libdir/%oname-%version/devices/videoinput
%_libdir/%oname-%version/devices/sound/*_pwplugin.so
%_libdir/%oname-%version/devices/videoinput/*_pwplugin.so

%changelog
