%define _name libqmi

Name: %_name-glib
Version: 1.12.10
Release: alt1.M70P.1

Summary: QMI modem protocol helper library
License: %lgpl2plus
Group: System/Libraries
URL: http://cgit.freedesktop.org/libqmi
# git://anongit.freedesktop.org/libqmi
Source: %name-%version.tar

Patch: %_name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildRequires: glib2-devel libgio-devel
BuildRequires: python-modules-json
BuildRequires: gtk-doc help2man

%description
libqmi is a glib-based library for talking to WWAN modems and devices
which speak the Qualcomm MSM Interface (QMI) protocol.

%package utils
Summary: QMI command line utilities
License: %gpl2plus
Group: System/Base
Requires: %name = %version-%release

%description utils
QMI command line utilities

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Requires: glib2-devel

%description devel
This package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: This package contains development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Requires: %name-devel = %version-%release

%description devel-doc
This package contains development documentation for %name

%prep
%setup
%patch -p1
touch README ChangeLog

%build
%autoreconf
%configure \
	--disable-static \
	--enable-gtk-doc \
	--with-tests
%make_build

# Fix qmicli name in the man page
sed -i 's;lt\\-qmicli;qmicli;' docs/man/qmicli.1

%install
%makeinstall_std

%check
make check

%files
%_libdir/*.so.*
%_libexecdir/qmi-proxy

%files utils
%_bindir/*
%_man1dir/qmicli.1*
%_man1dir/qmi-network.1*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%files devel-doc
%_datadir/gtk-doc/html/*


%changelog
