%define oname libqwt
Name: %{oname}6
Version: 6.0.1
Release: alt3.qa1

Summary: 2D plotting widget extension to the Qt GUI

License: LGPL
Group: System/Libraries
Url: http://sourceforge.net/projects/qwt

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://qwt.svn.sourceforge.net/svnroot/qwt/trunk/qwt
Source: qwt-%version.tar.bz2

Patch1: qwt-6.0.1-qwtconfig.pri.patch

#Provides: %oname = %version-%release

# Automatically added by buildreq on Tue Jul 21 2009
BuildRequires: gcc-c++ libqt4-devel libXext-devel doxygen graphviz

%description
Qwt is an extension to the Qt GUI library from Troll Tech AS.
The Qwt library contains widgets and components which are
primarily useful for technical and scientifical purposes.
It includes a 2-D plotting widget, different kinds of sliders,
and much more.

%package qt4-designer-plugin
Summary: Qwt plugin for qt4-designer
Group: Development/KDE and QT
Requires: %name = %version-%release
Conflicts: %name < %version-%release
Conflicts: %oname %{oname}5_3

%description qt4-designer-plugin
Qwt is an extension to the Qt GUI library from Troll Tech AS.
The Qwt library contains widgets and components which are
primarily useful for technical and scientifical purposes.
It includes a 2-D plotting widget, different kinds of sliders,
and much more.

This package contains Qwt plugin for qt4-designer

%package devel
Summary: Development tools for programs which uses Qwt Widget set
Group: Development/C
#Provides: %oname-devel = %version-%release
Requires: %name = %version-%release
Conflicts: %oname-devel %{oname}5_3-devel

%description devel
The libqwt-devel package contains the header files and libraries
necessary for developing programs using the Qwt Widget set

If you want to develop programs which will use this set of widgets,
you should install this package. You need also to install the libqwt package.

%package devel-doc
Summary: Documentation and examples for Qwt Widget set
Group: Development/Documentation
BuildArch: noarch
Conflicts: %oname-devel-doc %oname-devel %{oname}5_3-devel %{oname}5_3-devel-doc

%description devel-doc
This package contains development documentation and examples for Qwt
Widget set.

%prep
%setup

%patch1 -p0

sed -i "s|/lib|/%_lib|g" qwtconfig.pri
find . -type f -name '*.pro' |while read f; do
echo 'QMAKE_CXXFLAGS += %optflags' >> $f
done

%build
export QTDIR=%_qt4dir
export PATH=$QTDIR/bin:$PATH
qmake qwt.pro

# incompatible with SMP build
%make

pushd doc
doxygen
popd

%install
%make_install install INSTALL_ROOT=%buildroot

# man absent in 6.0.1
#install -d %buildroot%_man3dir
#install -m644 doc/man/man3/* %buildroot%_man3dir

# clean up the example tree
(cd examples; make distclean)
(cd examples; rm -f .*.cache */.*.cache */*/.*.cache)
(cd examples; rm -rf Makefile */moc */obj */*/moc */*/obj)

#install -d %buildroot%_qt4dir
#mv %buildroot%prefix/plugins %buildroot%_qt4dir/
#install -d %buildroot%_includedir/qwt
#mv %buildroot%_includedir/*.h %buildroot%_includedir/qwt/
#mv %buildroot%prefix/features/* %buildroot%_includedir/qwt/

%files
%doc CHANGES README COPYING
%_libdir/libqwt.so.*
%_libdir/libqwtmathml.so.*
%exclude %prefix/doc

%files qt4-designer-plugin
%dir %_qt4dir/plugins/designer
%_qt4dir/plugins/designer/*.so

%files devel
%_includedir/qwt
%_libdir/libqwt.so
%_libdir/libqwtmathml.so

%files devel-doc
%doc doc/html
%doc examples
#_man3dir/*

%changelog
