%define origname librapi2

Name: librapi
Version: 0.15.2
Release: alt2
Packager: Mobile Development Team <mobile@packages.altlinux.org>
Summary: A library that implements RAPI
License: MIT
Group: System/Libraries
Url: http://synce.sourceforge.net
Source: %origname-%version.tar
Source1: %name.map
Patch1: %name-alt-symver.patch
Patch2: %name-alt-disable-rpath.patch
Patch3: %name-alt-fix-link.patch

BuildPreReq: libsynce-devel >= 0.15.1
BuildPreReq: python-module-Pyrex >= 0.9.6
BuildPreReq: libdbus-glib-devel libdbus-devel
BuildRequires: gcc-c++ time

Provides: librapi2 = %version-%release
Obsoletes: librapi2

%description
Librapi is part of the SynCE project (%url).

The RAPI library is an open source implementation that works like RAPI.DLL,
available on Microsoft operating systems. The library makes it possible to make
remote calls to a computer running Pocket PC. Documentation for the RAPI calls
is available at this address:

http://msdn.microsoft.com/library/default.asp?url=/library/en-us/wcesdkr/htm/_wcesdk_CeRapiInit.asp

%package devel
Summary: Libraries and headers needed for developing with SynCE
Group: Development/C
Requires: %name = %version-%release

Provides: librapi2-devel = %version-%release
Obsoletes: librapi2-devel

%description devel
Libraries and headers needed for developing with RAPI

%package -n rapi-tools
Summary: Simple command line tools that use RAPI
Group: Communications

Provides: rapi2-tools = %version-%release
Obsoletes: rapi2-tools

%description -n rapi-tools
Simple command line tools that use RAPI


%package -n python-module-librapi
Summary: librapi python interface
Group: Development/Python
Requires: %name = %version-%release
Provides: librapi-python = %version-%release
Obsoletes: librapi-python

%description -n python-module-librapi
Python wrappers for %name

%prep
%setup -q -n %{name}2-%version
#%patch1 -p1
%patch2 -p1
%patch3 -p1
#install -p -m644 %SOURCE1 src/%name.map

%build
ACLOCAL="aclocal -I m4"  %autoreconf
%configure --disable-static --disable-hal-support --enable-odccm-support  --enable-udev-support
sed -i -e 's,^\(pyrapi2_la_LIBADD = \$(top_builddir)/src/librapi.la\),\1 -lpython%__python_version,g' python/Makefile
%make_build

%install
%make DESTDIR=%buildroot install

%files
%_libdir/*.so.*
%doc README* TODO

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
#%_datadir/aclocal

%files -n rapi-tools
%_bindir/*
%_man1dir/*
%_man3dir/*

%files -n python-module-librapi
%python_sitelibdir/*.so
%exclude %python_sitelibdir/*.la

%changelog
