%define bname librsvg
%define ver_major 2.36
%define api_ver 2.0
%define gtk_api_ver 2.0
%define gtk3_api_ver 3.0

%def_disable static
%def_disable gtk_doc
%def_enable pixbuf_loader
%def_enable gtk_theme
%def_enable introspection
%def_enable vala

Name: %bname
Version: %ver_major.4
Release: alt1

Summary: An SVG library based on libart
License: LGPLv2+
Group: System/Libraries
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/gnome/sources/%bname/%ver_major/%bname-%version.tar.xz

# From configure.in
%define fontconfig_ver 1.0.1
%define glib_ver 2.12.0
%define gio_ver 2.24.0
%define gtk_ver 2.22.0
%define gtk3_ver 3.0.0
%define libxml2_ver 2.7.0
%define cairo_ver 1.2.0
%define pango_ver 1.10.0
%define libgsf_ver 1.6.0
%define croco_ver 0.6.7
%define vala_ver 0.17.1.26

PreReq: libcroco >= %croco_ver

# From configure.in
BuildPreReq: libgtk+2-devel >= %gtk_ver
BuildPreReq: libgtk+3-devel >= %gtk3_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %gio_ver
BuildPreReq: libxml2-devel >= %libxml2_ver
BuildPreReq: libpango-devel >= %pango_ver
BuildPreReq: libcairo-devel >= %cairo_ver
BuildPreReq: fontconfig-devel freetype2-devel
BuildPreReq: libcroco-devel >= %croco_ver
BuildPreReq: libgsf-devel >= %libgsf_ver
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel}
BuildPreReq: libX11-devel libXt-devel
BuildRequires: gcc-c++ gtk-doc sgml-common zlib-devel
%{?_enable_vala:BuildRequires: vala-tools >= %vala_ver rpm-build-vala}

%description
An SVG library based on libart.

%package devel
Summary: Libraries and include files for developing with librsvg
Group: Development/C
Requires: %bname = %version-%release

%description devel
This package provides the necessary development libraries and include
files to allow you to develop with librsvg.

%package devel-doc
Summary: Development documentation for %bname
Group: Development/Documentation
BuildArch: noarch
Conflicts: %bname < %version-%release

%description devel-doc
%bname is a SVG library based on libart.
This package contains development documentation for %bname

%package devel-static
Summary: Static libraries for developing with librsvg
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package provides the necessary static libraries files to allow you
to build static software with librsvg.

%package utils
Summary: Utilities to manipulate SVG files
Group: Graphics
Requires: %bname = %version-%release

%description utils
This package contains small utilities to manipulate SVG files found in
%bname package.

%package utils-gtk3
Summary: Utility to view SVG files
Group: Graphics
Requires: %bname = %version-%release

%description utils-gtk3
This package provides simple GTK+3 based SVG viewer.

%package -n libgtk-engine-svg
Summary: A GTK+ engine for graphical themes that use SVG images.
Group: Graphical desktop/GNOME
Requires: %bname = %version-%release

%description -n libgtk-engine-svg
This package contains a GTK+2 engine that renders graphical themes with SVG
images in them.

%package gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name library

%package gir-devel
Summary: GObject introspection devel data for the %name library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the %name library


%define _gtk_docdir %_datadir/gtk-doc/html/

%prep
%setup -n %bname-%version

%build
%configure \
	%{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{?_enable_pixbuf_loader:--enable-pixbuf-loader} \
	%{?_enable_gtk_theme:--enable-gtk-theme} \
	%{?_enable_introspection:--enable-introspection=yes} \
	%{?_enable_vala:--enable-vala=yes}

%make_build

%install
%makeinstall_std

%files
%_libdir/*.so.*
%{?_enable_pixbuf_loader:%_libdir/gdk-pixbuf-%gtk_api_ver/*/loaders/*.so}
%{?_enable_pixbuf_loader:%_datadir/themes/*/gtk-%gtk_api_ver/*}
%doc AUTHORS NEWS README TODO

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/%bname-%gtk_api_ver.pc
%{?_enable_vala:%_vapidir/%name-%api_ver.vapi}

%files devel-doc
%_gtk_docdir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%{?_enable_pixbuf_loader:%_libdir/gdk-pixbuf-%gtk_api_ver/*/loaders/*.a}
%endif

%files utils
%_bindir/*
%exclude %_bindir/rsvg-view-3
%_man1dir/*

%files utils-gtk3
%_bindir/rsvg-view-3

%files -n libgtk-engine-svg
%_libdir/gtk-%gtk_api_ver/*/engines/libsvg.so

%if_enabled introspection
%files gir
%_typelibdir/Rsvg-%api_ver.typelib

%files gir-devel
%_girdir/Rsvg-%api_ver.gir
%endif

%exclude %_libdir/gtk-%gtk_api_ver/*/*/*.la
%{?_enable_pixbuf_loader:%exclude %_libdir/gdk-pixbuf-%gtk_api_ver/*/loaders/*.la}

%changelog
