%define ver_major 0.15
%define api_ver 1

%def_disable static
%def_enable gtk_doc
%def_enable introspection
%def_enable vala

Name: libsecret
Version: %ver_major
Release: alt2

Summary: A client library for the Secret Service DBus API
Group: System/Libraries
License: LGPLv2
Url: http://www.gnome.org/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define glib_ver 2.32.0

BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgcrypt-devel gtk-doc intltool xsltproc
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools}

# for check
BuildRequires: /proc xvfb-run dbus-tools-gui python-module-dbus python-module-pygobject libgjs

%description
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

%package devel
Summary: Development files and libraries for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

This package provides files for development with %name.

%package devel-doc
Summary: Development documentaion for %name
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

This package provides development documentations for %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name library.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for %name.


%prep
%setup

%build
%autoreconf
%configure --disable-static \
%{?_enable_gtk_doc:--enable-gtk-doc} \
%{subst_enable introspection}

%make_build

%install
%makeinstall_std

%find_lang %name

%check
# required X11
xvfb-run %make check

%files -f %name.lang
%_bindir/secret-tool
%_libdir/%name-%api_ver.so.*
%_man1dir/secret-tool.1.*
%doc AUTHORS README NEWS

%files devel
%_includedir/%name-%api_ver
%_libdir/%name-%api_ver.so
%_libdir/pkgconfig/%name-%api_ver.pc
%_libdir/pkgconfig/%name-unstable.pc
%if_enabled vala
%_vapidir/%name-%api_ver.vapi
%_vapidir/%name-%api_ver.deps
%_vapidir/%name-unstable.deps
%_vapidir/%name-unstable.vapi
%_vapidir/mock-service-0.vapi
%endif

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_typelibdir/Secret-%api_ver.typelib
%_typelibdir/SecretUnstable-0.typelib

%files gir-devel
%_girdir/Secret-%api_ver.gir
%_girdir/SecretUnstable-0.gir
%endif


%changelog
