%def_with python

Name: libselinux
Version: 2.1.12
Release: alt1
Summary: SELinux library
License: Public Domain
Group: System/Libraries
Url: http://userspace.selinuxproject.org/
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%{?_with_python:BuildPreReq: rpm-build-python}
BuildRequires: libpcre-devel libsepol-devel >= 2.1.4
%{?_with_python:BuildRequires: python-dev swig libsepol-devel-static >= 2.1.4}

%description
libselinux provides an API for SELinux applications to get and set
process and file security contexts and to obtain security policy
decisions.


%package devel
Summary: SELinux development library and header files
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development library and header files needed
for developing SELinux applications.


%package devel-static
Summary: Static SELinux library
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package contains static SELinux library needed for developing
statically linked SELinux applications.


%package utils
Summary: SELinux utilities
Group: System/Configuration/Other
Requires: %name = %version-%release

%description utils
This package provides utility programs to get and set process and
file security contexts and to obtain security policy decisions.


%if_with python
%package -n python-module-selinux
%setup_python_module selinux
Summary: Python module for %name
Group: System/Configuration/Other
Requires: %name = %version-%release

%description -n python-module-selinux
This package contains SELinux python bindings.
%endif


%prep
%setup -q
%patch -p1


%build
%make_build CFLAGS="%optflags $(pkg-config libpcre --cflags)" LIBDIR=%_libdir all
%{?_with_python:%make_build CFLAGS="%optflags" LIBDIR=%_libdir pywrap}


%install
%makeinstall_std LIBDIR=%buildroot%_libdir SHLIBDIR=%buildroot/%_lib %{?_with_python:install-pywrap}
install -d -m 0755 %buildroot/var/run/setrans


%post
TELINIT=/sbin/telinit
[ -x $TELINIT -a -L /proc/1/exe -a -L /proc/1/root ] && $TELINIT u ||:


%files
/%_lib/*.so.*
%_man8dir/booleans.*
%_man8dir/selinux.*
%dir /var/run/setrans


%files devel
%_libdir/*.so
%_includedir/selinux
%_pkgconfigdir/*
%_man3dir/*


%files devel-static
%_libdir/*.a


%files utils
%_sbindir/*
%_man5dir/*
%_man8dir/*
%exclude %_man8dir/booleans.*
%exclude %_man8dir/selinux.*


%if_with python
%files -n python-module-selinux
%python_sitelibdir/*
%endif


%changelog
