%def_disable check
%def_with python

Name: libsemanage
Version: 2.1.9
Release: alt1
Summary: Library, which provides an interface for SELinux management
Group: System/Libraries
License: LGPLv2.1+
Url: http://userspace.selinuxproject.org
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%{?_with_python:BuildPreReq: rpm-build-python}
BuildRequires: bzlib-devel flex libustr-devel libsepol-devel >= 2.1 libselinux-devel >= 2.1
%{?_with_python:BuildRequires: swig python-dev}
%{!?_disable_check:BuildRequires: CUnit-devel libsepol-devel-static >= 2.1 libselinux-devel-static >= 2.1}

%description
This package provides the shared libraries for the manipulation of
SELinux binary policies. It is used by checkpolicy (the policy compiler)
and similar tools, as well as by programs like load_policy that need
to perform specific transformations on binary policies such as
customizing policy boolean settings. This contains the run-time
libraries needed by such tools.


%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version

%description devel
Header files and libraries for SELinux policy manipulation tools
This package provides an API for the manipulation of SELinux binary policies.
It is used by checkpolicy (the policy compiler) and similar tools, as
well as by programs like load_policy that need to perform specific
transformations on binary policies such as customizing policy boolean
settings. It contains the static libraries and header files needed
for developing applications that manipulate SELinux binary policies.


%package devel-static
Summary: Development files for %name
Group: Development/C
Requires: %name-devel = %version

%description devel-static
Static libraries for SELinux policy manipulation tools.


%if_with python
%package -n python-module-semanage
Summary: Python module for %name
Group: System/Configuration/Other
Requires: %name = %version

%description -n python-module-semanage
Python bindings  for SELinux policy manipulation tools
This package provides python bindings for the manipulation of SELinux
binary policies.
%endif


%prep
%setup -q
%patch -p1


%build
%make_build CFLAGS="%optflags" LIBDIR=%_libdir SHLIBDIR=%_lib all
%{?_with_python:%make_build CFLAGS="%optflags" LIBDIR=%_libdir SHLIBDIR=%_lib pywrap}


%install
%makeinstall_std LIBDIR=%buildroot/%_libdir SHLIBDIR=%buildroot/%_lib %{?_with_python:install-pywrap}
ln -sf /%_lib/libsemanage.so.1 %buildroot/%_libdir/libsemanage.so


%check
%make_build test


%files
%dir %_sysconfdir/selinux
%config(noreplace) %_sysconfdir/selinux/*
/%_lib/*.so.*
%_man5dir/*


%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_man3dir/*


%files devel-static
%_libdir/*.a


%if_with python
%files -n python-module-semanage
%python_sitelibdir/*
%endif


%changelog
