Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ pkgconfig(alsa)
# END SourceDeps(oneline)
Name:           libsigrok
Version:        0.1.1
Release:        alt1_3
Summary:        Basic hardware access drivers for logic analyzers
# Combined GPLv3+ and GPLv2+ and BSD
License:        GPLv3+
URL:            http://www.sigrok.org/
Source0:        http://downloads.sourceforge.net/sigrok/%{name}-%{version}.tar.gz

BuildRequires:  glib2-devel
BuildRequires:  libzip-devel
BuildRequires:  zlib-devel
BuildRequires:  libudev-devel
BuildRequires:  libusb-devel
BuildRequires:  libftdi-devel
BuildRequires:  doxygen
BuildRequires:  graphviz
Source44: import.info

%description
%{name} is a shared library written in C which provides the basic API for
talking to logic analyzer hardware and reading/writing the acquired data into
various input/output file formats.


%package        devel
Group: Other
Summary:        Development files for %{name}
Requires:       %{name}%{?_isa} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%package        doc
Group:          Documentation
Summary:        API documentation for %{name}
BuildArch:      noarch

%description    doc
The %{name}-doc package contains documentation for developing software
with %{name}.

%prep
%setup -q


%build
# "alsa" and "link-mso19" are incomplete drivers, and do not compile
%configure --disable-static \
  --disable-alsa \
  --enable-asix-sigma \
  --enable-chronovu-la8 \
  --enable-fx2lafw \
  --enable-demo \
  --disable-link-mso19 \
  --enable-ols \
  --enable-zeroplus-logic-cube
make %{?_smp_mflags}

# This builds documentation for the -doc package
# A few warnings are generated by doxygen, which should be fixed in the next
# upstream release
doxygen Doxyfile


%install
%makeinstall_std
find %{buildroot} -name '*.la' -exec rm -f {} ';'


%files
%doc README NEWS COPYING ChangeLog
%{_libdir}/libsigrok.so.0*

%files devel
%{_includedir}/sigrok*.h
%{_libdir}/libsigrok.so
%{_libdir}/pkgconfig/libsigrok.pc

%files doc
%doc doxy/html/

%changelog
