Name: libsigsegv
Version: 2.10
Release: alt1

Summary: Library for handling page faults in user mode
License: GPLv2+
Group: System/Libraries
Url: http://www.gnu.org/software/libsigsegv/
# git://git.altlinux.org/gears/l/libsigsegv
Source: %name-%version-%release.tar
%define libname %{name}2
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

%description
This is a library for handling page faults in user mode.  A page fault
occurs when a program tries to access to a region of memory that is
currently not available.  Catching and handling a page fault is a useful
technique for implementing:
  - pageable virtual memory
  - memory-mapped access to persistent databases
  - generational garbage collectors
  - stack overflow handlers
  - distributed shared memory

%package -n %libname
Summary: Library for handling page faults in user mode
Group: System/Libraries
Provides: %name = %version-%release
Obsoletes: %name < %version-%release

%description -n %libname
This is a library for handling page faults in user mode.  A page fault
occurs when a program tries to access to a region of memory that is
currently not available.  Catching and handling a page fault is a useful
technique for implementing:
  - pageable virtual memory
  - memory-mapped access to persistent databases
  - generational garbage collectors
  - stack overflow handlers
  - distributed shared memory

%package devel
Summary: GNU libsigsegv development library and header files
Group: Development/C
Requires: %libname = %version-%release

%description devel
The development library and header files for building applications
with GNU libsigsegv.

%prep
%setup -n %name-%version-%release

%build
%autoreconf
%configure --enable-shared --disable-static
%make_build

%install
%makeinstall_std

%check
%make_build -k check

%files -n %libname
%_libdir/*.so.*
%doc AUTHORS README NEWS

%files devel
%_libdir/*.so
%_includedir/*

%changelog
