%define api_ver 2.4
%define ver_major 2.42
%def_disable static
%def_enable gtk_doc
%def_with gnome
%def_enable introspection

Name: libsoup
Version: %ver_major.3.1
Release: alt1.M70P.2

Summary: HTTP client/server library for GNOME
Group: System/Libraries
License: LGPLv2+
Url: https://live.gnome.org/LibSoup
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

#Source: %name-%version.tar
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Source1: %name-compat.map
Source2: %name-compat.lds
Source3: %name-gnome-compat.map
Source4: %name-gnome-compat.lds
Patch1: %name-2.41.3-alt-compat-map.patch
# time out test fails in build system not in local hasher
Patch100: %name-2.32.2-no-timeout_test.patch
Patch101: %name-2.42.3-soup-session-feature-work-around-an-old-Eclipse-bug.patch

Requires: glib-networking >= 2.35.3

Provides: soup = %version libsoup%api_ver = %version
Obsoletes: soup < %version libsoup%api_ver < %version

%define glib_ver 2.35.0
%define gi_ver 1.33.3

# from configure.in
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libxml2-devel libsqlite3-devel zlib-devel

BuildRequires: docbook-dtds docbook-style-xsl common-licenses
BuildRequires: gtk-doc xml-common xsltproc intltool
BuildRequires: glib-networking
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= %gi_ver}
# for check
BuildRequires: /proc curl

%description
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

%package gnome
Summary: HTTP client/server library for GNOME (GNOME part)
Group: System/Libraries
Requires: %name = %version-%release

%description gnome
Simple Object Access Protocol implementation Library (GNOME part)

%package devel
Summary: Headers for HTTP client/server library for GNOME
Group: Development/C
Requires: %name = %version-%release
Provides: soup-devel = %version libsoup%api_ver-devel = %version
Obsoletes: soup-devel = %version libsoup%api_ver-devel < %version

%description devel
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package allows to develop applications that use the Soup library.

%package gnome-devel
Summary: Headers for HTTP client/server library for GNOME (GNOME part)
Group: Development/C
Requires: %name-gnome = %version-%release
Requires: %name-devel = %version-%release

%description gnome-devel
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package allows to develop applications that use the Soup library.

%package devel-doc
Summary: Development documentation for HTTP client/server library for GNOME
Group: Development/Documentation
Conflicts: %name < %version
Provides: libsoup%api_ver-devel-doc = %version
Obsoletes: libsoup%api_ver-devel-doc < %version
BuildArch: noarch

%description devel-doc
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package contains development documentation for Soup.

%package devel-static
Summary: Headers for Simple Object Access Protocol static library
Group: Development/C
Requires: %name-devel = %version-%release
Provides: soup-devel-static = %version libsoup%api_ver-devel-static = %version
Obsoletes: soup-devel-static < %version libsoup%api_ver-devel-static < %version

%description devel-static
This package allows to develop applications that statically linked
against Soup library.

%package gir
Summary: GObject introspection data for the Soup library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package provides GObject introspection data for the Soup library

%package gir-devel
Summary: GObject introspection devel data for the Soup library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package provides GObject introspection devel data for the Soup library

%package gnome-gir
Summary: GObject introspection data for the Soup-GNOME library
Group: System/Libraries
Requires: %name-gir = %version-%release
Requires: %name-gnome = %version-%release

%description gnome-gir
This package provides GObject introspection data for the GNOME part of Soup library

%package gnome-gir-devel
Summary: GObject introspection devel data for the Soup-GNOME library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir-devel = %version-%release
Requires: %name-gnome-gir = %version-%release

%description gnome-gir-devel
This package provides GObject introspection devel data for the GNOME
part of Soup library.

%prep
%setup -q
install -p -m644 %_sourcedir/%name-{,gnome-}compat.{map,lds} %name/
%patch1 -p1
%patch101 -p1
#%%patch100 -b .notimeout_test

%build
%autoreconf
%configure \
    %{subst_enable static} \
    %{subst_with gnome} \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    %{subst_enable introspection}

%make_build

%check
# some tests failed in hasher
%make check

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_libdir/%name-%api_ver.so.*
%doc README NEWS AUTHORS

%files gnome
%_libdir/%name-gnome-%api_ver.so.*

%files devel
%_includedir/%name-%api_ver/
%_libdir/%name-%api_ver.so
%_libdir/pkgconfig/%name-%api_ver.pc

%files gnome-devel
%_includedir/%name-gnome-%api_ver/
%_libdir/%name-gnome-%api_ver.so
%_libdir/pkgconfig/%name-gnome-%api_ver.pc

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files gir
%_typelibdir/Soup-%api_ver.typelib

%files gir-devel
%_girdir/Soup-%api_ver.gir

%files gnome-gir
%_typelibdir/SoupGNOME-%api_ver.typelib

%files gnome-gir-devel
%_girdir/SoupGNOME-%api_ver.gir
%endif

%changelog
