%def_enable tests

Name: libtalloc
Version: 2.1.8
Release: alt0.M70P.1
Epoch:   1

Summary: The talloc library

License: LGPLv3+
Group: System/Libraries
Url: http://talloc.samba.org/

Source: http://samba.org/ftp/talloc/talloc-%version.tar.gz
Patch1: talloc-fix-tests.patch

BuildRequires: docbook-dtds docbook-style-xsl libacl-devel libcap-devel python-devel xsltproc

%description
A library that implements a hierarchical allocator with destructors.

%package devel
Group: Development/C
Summary: Developer tools for the Talloc library
Requires: %name = %version-%release

%package -n libpytalloc
Group: Development/Tools
Summary: Developer tools for the Talloc library
Requires: libtalloc = %version-%release

%description -n libpytalloc
Pytalloc libraries for creating python bindings using talloc

%package -n libpytalloc-devel
Group: Development/C
Summary: Developer tools for the Talloc library
Requires: libpytalloc = %version-%release

%description -n libpytalloc-devel
Development libraries for libpytalloc

%description devel
Header files needed to develop programs that link against the Talloc
library.

%prep
%setup -q -n talloc-%version
%patch1 -p2

%build
%undefine _configure_gettext
%configure	--disable-rpath \
		--disable-rpath-install \
		--bundled-libraries=NONE \
		--builtin-libraries=replace \
		--disable-silent-rules
%make_build

%install
%makeinstall_std

rm -f %buildroot%_libdir/*.a
rm -f %buildroot%_datadir/swig/*/talloc.i

%if_enabled tests
%check
export LD_LIBRARY_PATH=./bin/shared:$LD_LIBRARY_PATH
make test
%endif

%files
%_libdir/libtalloc.so.*

%files devel
%_includedir/talloc.h
%_libdir/libtalloc.so
%_pkgconfigdir/talloc.pc
%_man3dir/talloc.3.*

%files -n libpytalloc
%_libdir/libpytalloc-util.so.*
%python_sitelibdir/talloc.so

%files -n libpytalloc-devel
%_includedir/pytalloc.h
%_pkgconfigdir/pytalloc-util.pc
%_libdir/libpytalloc-util.so


%changelog
