%def_enable tests

Name: libtevent
Version: 0.9.29
Release: alt0.M70P.1
Summary: The tevent library
License: LGPLv3+
Group: System/Libraries
Url: http://tevent.samba.org/

Source: http://samba.org/ftp/tevent/tevent-%{version}.tar.gz

BuildRequires: libtalloc-devel >= 2.1.0
BuildRequires: libpytalloc-devel >= 2.1.0
BuildRequires: python-devel zlib-devel

%description
Tevent is an event system based on the talloc memory management library.
Tevent has support for many event types, including timers, signals, and
the classic file descriptor events.
Tevent also provide helpers to deal with asynchronous code providing the
tevent_req (Tevent Request) functions.

%package devel
Group: Development/C
Summary: Developer tools for the Tevent library
Requires: %name = %version-%release

%description devel
Header files needed to develop programs that link against the tevent library.

%package -n python-module-tevent
Group: Development/Python
Summary: Python bindings for the Tevent library
Requires: %name = %version-%release

%description -n python-module-tevent
Python bindings for libtevent

%prep
%setup -n tevent-%version

%build
%undefine _configure_gettext
%configure \
	--disable-rpath \
	--bundled-libraries=NONE \
	--builtin-libraries=replace

%make_build

%install
%makeinstall_std

rm -f %buildroot%_libdir/*.a

%if_enabled tests
%check
export LD_LIBRARY_PATH=./bin/shared:$LD_LIBRARY_PATH
make test
%endif

%files
%_libdir/*.so.*

%files devel
%_includedir/*.h
%_libdir/*.so
%_pkgconfigdir/*.pc

%files -n python-module-tevent
%python_sitelibdir/_tevent.so
%python_sitelibdir/tevent.py*

%changelog
