Name: libtiff
Version: 4.0.3
Release: alt1

Summary: Library of functions for manipulating TIFF format image files
License: BSD-style
Group: System/Libraries
Url: http://www.remotesensing.org/libtiff/

# git://git.altlinux.org/gears/l/%name
Source: %name-%version-%release.tar

%def_disable static
%def_enable cxx

BuildRequires: gcc-c++ libSM-devel libXi-devel libXmu-devel libfreeglut-devel libjpeg-devel liblzma-devel zlib-devel

%description
This package contains a library of functions for manipulating
TIFF (Tagged Image File Format) image format files.  TIFF is a widely
used file format for bitmapped images.  TIFF files usually end in the
.tif extension and they are often quite large.

%package -n libtiff5
Summary: Library of functions for manipulating TIFF format image files
Group: System/Libraries

%package utils
Summary: Programs for manipulating TIFF format image files
Group: Graphics
Requires: libtiff5 = %version-%release

%package -n tiffgt
Summary: Program for viewing TIFF format image files
Group: Graphics
Requires: libtiff5 = %version-%release

%package devel
Summary: Development files for programs which will use the tiff library
Group: Development/C
Requires: libtiff5 = %version-%release
Provides: libtiff5-devel
Obsoletes: libtiff5-devel

%package devel-static
Summary: Static tiff library
Group: Development/C
Requires: %name-devel = %version-%release

%package -n libtiffxx5
Summary: TIFF I/O C++ shared library
Group: System/Libraries
Requires: libtiff5 = %version-%release

%package -n libtiffxx-devel
Summary: TIFF I/O C++ development library and header files
Group: Development/C
Requires: libtiffxx5 = %version-%release

%description -n libtiff5
This package contains a library of functions for manipulating
TIFF (Tagged Image File Format) image format files.  TIFF is a widely
used file format for bitmapped images.  TIFF files usually end in the
.tif extension and they are often quite large.

%description utils
This package contains simple client programs for accessing
the tiff functions.

%description -n tiffgt
This package contains tiffgt - a TIFF file display program.

%description devel
This package contains the header files for developing programs which
will manipulate TIFF format image files using the tiff library.

%description devel-static
This package contains static %name library.

%description -n libtiffxx5
This package contains TIFF I/O C++ shared library

%description -n libtiffxx-devel
This package contains TIFF I/O C++ development library and header files.

%prep
%setup -n %name-%version-%release
:>port/dummy.c

cd libtiff
cat > libtiff.sym << EOF
TIFFFaxBlackCodes
TIFFFaxBlackTable
TIFFFaxMainTable
TIFFFaxWhiteCodes
TIFFFaxWhiteTable
_TIFFCheckMalloc
_TIFFDataSize
_TIFFFax3fillruns
_TIFFMultiply32
_TIFFRewriteField
display_sRGB
EOF
sed -n 's/^extern[^)]\+[[:space:]]\*\?\([^[:space:]*()]\+\)[[:space:]]*(.*/\1/p' \
	tiffio.h >> libtiff.sym
sort -u -o libtiff.sym{,}
cat > libtiff.map << EOF
{
 global:
$(sed 's/.*/  &;/' libtiff.sym)
 local:
  *;
};
EOF
rm libtiff.sym

%build
./autogen.sh
%define docdir %_docdir/%name-%version
%configure --with-docdir=%docdir --enable-ld-version-script \
	%{subst_enable static} %{subst_enable cxx}
%make_build X_PRE_LIBS= GLUT_CFLAGS= GLUT_CFLAGS= GLUT_LIBS='-lglut -lGL' \
	GLU_CFLAGS= GLU_LIBS= GL_CFLAGS= GL_LIBS=

%install
%makeinstall_std
xz -9 %buildroot%docdir/ChangeLog

%check
%make_build -k check

%files -n libtiff5
%_libdir/%name.so.?*
%dir %docdir
%docdir/[A-Z]*

%files utils
%_bindir/*
%_man1dir/*.*
%exclude %_bindir/tiffgt
%exclude %_man1dir/tiffgt.*

%files -n tiffgt
%_bindir/tiffgt
%_man1dir/tiffgt.*

%files devel
%_pkgconfigdir/*.pc
%_libdir/%name.so
%_includedir/*.h
%_man3dir/*.*
%dir %docdir
%docdir/html

%if_enabled static
%files devel-static
%_libdir/%name.a
%endif

%if_enabled cxx
%files -n libtiffxx5
%_libdir/libtiffxx.so.*

%files -n libtiffxx-devel
%_libdir/libtiffxx.so
%_includedir/*.hxx
%endif

%changelog
