Name: libtiff4
Version: 3.9.6
Release: alt4

Summary: Library of functions for manipulating TIFF format image files
License: BSD-style
Group: System/Legacy libraries
Url: http://www.remotesensing.org/libtiff/

# git://git.altlinux.org/gears/l/%name
Source: %name-%version-%release.tar

%def_enable compat
%def_disable static
%def_enable cxx

# Automatically added by buildreq on Tue Feb 08 2011
BuildRequires: gcc-c++ libSM-devel libXi-devel libXmu-devel libfreeglut-devel libjpeg-devel zlib-devel

Provides: libtiff = %version-%release
Obsoletes: libtiff < %version-%release

%package utils
Summary: Programs for manipulating TIFF format image files
Group: Graphics
Requires: %name = %version-%release

%package -n tiffgt
Summary: Program for viewing TIFF format image files
Group: Graphics
Requires: %name = %version-%release

%package devel
Summary: Development files for programs which will use the tiff library
Group: Development/C
Requires: %name = %version-%release

%package devel-static
Summary: Static tiff library
Group: Development/C
Requires: %name-devel = %version-%release

%package -n libtiffxx0
Summary: TIFF I/O C++ shared library
Group: System/Legacy libraries
Requires: %name = %version-%release
Provides: libtiffxx = %version-%release
Obsoletes: libtiffxx < %version-%release

%package -n libtiffxx-devel
Summary: TIFF I/O C++ development library and header files
Group: Development/C
Requires: libtiffxx0 = %version-%release

%description
This package contains a library of functions for manipulating
TIFF (Tagged Image File Format) image format files.  TIFF is a widely
used file format for bitmapped images.  TIFF files usually end in the
.tif extension and they are often quite large.

%description utils
This package contains simple client programs for accessing
the tiff functions.

%description -n tiffgt
This package contains tiffgt - a TIFF file display program.

%description devel
This package contains the header files for developing programs which
will manipulate TIFF format image files using the tiff library.

%description devel-static
This package contains static %name library.

%description -n libtiffxx0
This package contains TIFF I/O C++ shared library

%description -n libtiffxx-devel
This package contains TIFF I/O C++ development library and header files.

%prep
%setup -n %name-%version-%release
:>port/dummy.c

cd libtiff
cat > libtiff.sym << EOF
TIFFFaxBlackCodes
TIFFFaxBlackTable
TIFFFaxMainTable
TIFFFaxWhiteCodes
TIFFFaxWhiteTable
_TIFFCheckMalloc
_TIFFDataSize
_TIFFFax3fillruns
display_sRGB
EOF
sed -n 's/^extern[^)]\+[[:space:]]\*\?\([^[:space:]*()]\+\)[[:space:]]*(.*/\1/p' \
	tiffio.h >> libtiff.sym
sort -u -o libtiff.sym{,}
cat > libtiff.map << EOF
{
 global:
$(sed 's/.*/  &;/' libtiff.sym)
 local:
  *;
};
EOF
rm libtiff.sym

%build
./autogen.sh
%define docdir %_docdir/%name-%version
%configure --with-docdir=%docdir --enable-ld-version-script \
	%{subst_enable static} %{subst_enable cxx}
%make_build X_PRE_LIBS= GLUT_CFLAGS= GLUT_CFLAGS= GLUT_LIBS='-lglut -lGL' \
	GLU_CFLAGS= GLU_LIBS= GL_CFLAGS= GL_LIBS=

%install
%makeinstall_std
bzip2 -9 %buildroot%docdir/ChangeLog

%check
%make_build -k check

%files
%_libdir/libtiff.so.?*
%dir %docdir
%docdir/[A-Z]*

%if_disabled compat
%files utils
%_bindir/*
%_man1dir/*.*
%exclude %_bindir/tiffgt
%exclude %_man1dir/tiffgt.*

%files -n tiffgt
%_bindir/tiffgt
%_man1dir/tiffgt.*

%files devel
%_libdir/libtiff.so
%_includedir/*.h
%_man3dir/*.*
%dir %docdir
%docdir/html

%if_enabled static
%files devel-static
%_libdir/libtiff.a
%endif
%endif #compat

%if_enabled cxx
%files -n libtiffxx0
%_libdir/libtiffxx.so.*

%if_disabled compat
%files -n libtiffxx-devel
%_libdir/libtiffxx.so
%_includedir/*.hxx
%endif
%endif #compat

%changelog
