Name: libtommath
Version: 0.42.0
Release: alt1
Summary: A portable number theoretic multiple-precision integer library
Group: System/Libraries
License: WTFPL
Url: http://libtom.org/
Source0: http://www.libtom.org/files/ltm-%version.tar.bz2

BuildRequires: texlive-latex-recommended

# Automatically added by buildreq on Wed Sep 14 2011
# optimized out: fontconfig ghostscript-classic ghostscript-common tex-common texlive-base texlive-base-bin texlive-common texlive-generic-recommended texlive-latex-base texlive-latex-recommended texlive-xetex
BuildRequires: ghostscript-utils libtiff-utils

Patch0: libtommath-makefile.patch

%description
A free open source portable number theoretic multiple-precision integer
library written entirely in C. (phew!). The library is designed to
provide a simple to work with API that provides fairly efficient
routines that build out of the box without configuration.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-static
Summary: Static development files for %name
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
The %name-devel-static package contains static libraries for
developing applications that use %name.

%package doc
Summary: Documentation files for %name
Group: Documentation
Requires: %name = %version-%release

%description doc
The %name-doc package contains PDF documentation for
using %name.

%prep
%setup
%patch0 -p1 -b .makefile

%build
%make_build LIBPATH=%_libdir -f makefile.shared
%make_build -f makefile poster manual docs

%install
# There is no configure script that ships with libtommath but it does
# understand DESTDIR and it installs via that and the
# INSTALL_USER and INSTALL_GROUP environment variables.

export INSTALL_USER=$(id -un)
export INSTALL_GROUP=$(id -gn)
make install INCPATH=%_includedir/tommath DESTDIR=%buildroot LIBPATH=%_libdir -f makefile.shared
find %buildroot -name '*.la' -exec rm -f {} ';'
find %buildroot -name '*.h' -exec chmod 644 {} ';'

%files
%doc LICENSE
%_libdir/*.so.*

%files devel
%doc LICENSE
%_includedir/tommath
%_libdir/*.so

%files devel-static
%_libdir/*.a

%files doc
%doc LICENSE
%doc bn.pdf poster.pdf tommath.pdf

%changelog
