%define ltversion 2.4
%define ltsoname 7
%define libtool libtool-%ltversion
%define libltdl libltdl%ltsoname
%define priority 242

Name: libtool_%ltversion
Version: 2.4.2
Release: alt2

Summary: The GNU libtool, which simplifies the use of shared libraries
License: GPLv2+
Group: Development/Other
Url: http://www.gnu.org/software/libtool/libtool.html

%add_findreq_skiplist %_datadir/%libtool/config.guess
%set_compress_method gzip

Provides: libtool = 3:%version-%release
Obsoletes: libtool
PreReq: libtool-common >= 0.2, alternatives >= 0:0.4
Requires: aclocal(libtool)
Requires: autoconf_2.60

# git://git.altlinux.org/gears/l/%name.git
Source: libtool-%version-%release.tar

BuildRequires: gcc-c++ gcc-g77
# for tests/search-path.at
BuildRequires: zlib-devel

%package -n %libltdl
Summary: dlopen wrapper for GNU libtool
License: LGPLv2+
Group: System/Libraries

%package -n %libltdl-devel
Summary: Development files for %libltdl
License: LGPLv2+
Group: Development/C
Requires: %name = %version-%release
Requires: %libltdl = %version-%release
Provides: libltdl-devel = 3:%version-%release
Conflicts: libltdl-devel < 3:%version

%package -n %libltdl-devel-static
Summary: Static %libltdl library
License: LGPLv2+
Group: Development/C
Requires: %libltdl-devel = %version-%release
Provides: libltdl-devel-static = 3:%version-%release
Conflicts: libltdl-devel-static < 3:%version

%package demos
Summary: Samples for Libtool
License: GPLv2+
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description
The libtool package contains the GNU libtool, a set of shell scripts
which automatically configure UNIX and UNIX-like architectures to
generically build shared libraries.  Libtool provides a consistent,
portable interface which simplifies the process of using shared
libraries.

If you are developing programs which will use shared libraries, you
should install libtool.

%description -n %libltdl
This package contains libltdl shared library,
a system independent dlopen wrapper for GNU libtool.

%description -n %libltdl-devel
Development files for libltdl, a system independent
dlopen wrapper for GNU libtool.

%description -n %libltdl-devel-static
Static libltdl library, a system independent dlopen wrapper for GNU libtool.

%description demos
Sample programs and libraries to build with libtool.

%prep
%setup -n libtool-%version

# Eliminate gnutar dependencies.
find -type f -name missing -print0|
	xargs -r0 sed -i 's/gnutar /gnutar=gnutar \&\& \$&/' --

# Rename due to alternatives.
sed -i '/@direntry/,/@end direntry/ s/^\(\*[[:space:]]\+[[:alnum:].]\+\)\(:[[:space:]]\+\)(libtool)/\1-%ltversion\2(%libtool)/' \
	doc/libtool.texi

%build
./bootstrap
%configure --program-suffix=-%ltversion

# SMP-incompatible build?
make MAKEINFOFLAGS=--no-split
# Do not hardcode gcc path information, and do not use -nostdlib.
sed -i -e 's/^\(predep_objects\|postdep_objects\|compiler_lib_search_path\)=.*/\1=""/' \
       -e 's/^\(archive\(_expsym\)\?_cmds=\".*\) -nostdlib /\1 /' libtool

%check
# Testsuite is SMP-compatible but the output is hard to read.
make -k check
find tests -maxdepth 1 -type d -name '*demo*' |
	xargs -rn1 make distclean -C

%install
%makeinstall_std
mv %buildroot%_infodir/libtool{,-%ltversion}.info

out="\$(\$CC -print-search-dirs |\$SED -e '/^libraries: *=/!d;s///;s!/:!:!g;s!/\$!!;s/:/ /g')"
sed -i 's#^\(compiler_lib_search_dirs="\)/.*#\1'"$out"'"#' %buildroot%_bindir/%libtool

mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/libtool-default	%_bindir/%libtool	%priority
%_bindir/libtoolize-default	%_bindir/libtoolize-%ltversion	%_bindir/%libtool
%_datadir/libtool	%_datadir/%libtool	%_bindir/%libtool
%_infodir/libtool.info.gz	%_infodir/%libtool.info.gz	%_bindir/%libtool
EOF

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo libtool >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name
mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
echo '^/usr/share/libtool(-2\.2)?/aclocal/.+\.m4$' >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name

%define ltdocdir %_docdir/libtool-%version
%define ltdldocdir %_docdir/libltdl-%version

rln()
{
	local target=$1 && shift
	local source=$1 && shift
	target=`relative "$target" "$source"`
	ln -snf "$target" "%buildroot$source"
}

mkdir -p %buildroot%ltdocdir
install -p -m644 AUTHORS NEWS README THANKS TODO %buildroot%ltdocdir/
rln %_licensedir/GPL-2 %ltdocdir/COPYING
mkdir -p %buildroot%ltdldocdir
install -p -m644 libltdl/README %buildroot%ltdldocdir/
rm %buildroot%_datadir/%libtool/libltdl/COPYING.LIB
rln %_licensedir/LGPL-2.1 %_datadir/%libtool/libltdl/COPYING.LIB
rln %_licensedir/LGPL-2.1 %ltdldocdir/COPYING.LIB

for d in `find tests -maxdepth 1 -type d -name '*demo*'`; do
	cp -a "$d" %buildroot%ltdocdir/
	rm -rf %buildroot%ltdocdir/"${d##*/}"/autom4te.cache
	find %buildroot%ltdocdir/"${d##*/}"/ -type f -print0 |
		xargs -r0 fgrep -lZ ../../libltdl/m4/ |
		xargs -r0 sed -i 's|libltdl/m4/|../libtool-%ltversion/aclocal/|' --
done

# This config.guess file usually emits tons of unwanted deps.
%add_findreq_skiplist %_datadir/%libtool/config/config.guess

%files
%_bindir/*
%_datadir/%libtool
%_infodir/%libtool.info*
%_altdir/%name
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/%name
%dir %ltdocdir
%ltdocdir/[A-Z]*

%files -n %libltdl
%_libdir/*.so.*
%dir %ltdldocdir
%ltdldocdir/README
%ltdldocdir/COPYING.LIB

%files -n %libltdl-devel
%_libdir/*.so
%_includedir/*

%files -n %libltdl-devel-static
%_libdir/*.a

%files demos
%dir %ltdocdir
%ltdocdir/*demo*

%changelog
