%def_disable debug
%def_disable static
%if_disabled debug
%remove_optflags -O2
%add_optflags -O3
%endif
%define abiversion 8
%define upname libtorrent-rasterbar

Name: libtorrent-rasterbar%{abiversion}
Version: 1.0.0
Epoch: 2
Release: alt2.svn7980

Summary: libTorrent is a BitTorrent library written in C++ for *nix
Group: System/Libraries
License: GPL
Url: http://www.rasterbar.com/products/libtorrent
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildRequires: libssl-devel
BuildRequires: gcc-c++ zlib-devel
BuildRequires: glibc-devel glibc-core
BuildRequires: boost-devel boost-asio-devel boost-filesystem
BuildRequires: boost-filesystem-devel boost-program_options-devel
BuildRequires: python-devel boost-python-devel
BuildRequires: libGeoIP-devel
Obsoletes: libtorrent <= 0.13-alt3.svn.r2433
Obsoletes: libtorrent-rasterbar0.15

%description
libTorrent is designed to avoid redundant copying and storing of data
that other clients and libraries suffer from. libTorrent features:

* The client has full control over the polling of sockets.
* Sigc++ signals makes it easy for the client to react to events.
* Fast resume which checks the file modification time.
* Direct reading and writing from network to mmap'ed files.
* File hash check uses the same thread; client can control the rate;
  non-blocking and preload to memory with the mincore and madvise.
* File handler: fine-grained use of file read/write permissions, allows
  seeding of read-only files; allows torrents with unlimited number of
  files; opens closed files when mapping chunks to memory, with graceful
  error handling; support for files larger than 2 GB; different download
  priorities for files in the torrent.
* Multi-tracker support.
* No dependency on any specific HTTP library, the client implements a
  wrapper class.
* Dynamic request pipe size.
* Upload and download throttle.
* And much more...

%package -n %upname-devel
Summary: Development libraries and header files for libTorrent
Group: Development/C++
Requires: %name = %epoch:%version-%release
Provides: libtorrent-rasterbar7-devel = %epoch:%version-%release
Conflicts: libtorrent-rasterbar7-devel < %epoch:%version-%release
Obsoletes: libtorrent-rasterbar7-devel < %epoch:%version-%release
Conflicts: libtorrent-rasterbar-devel < %epoch:%version-%release
Obsoletes: libtorrent-rasterbar-devel < %epoch:%version-%release
Conflicts: libtorrent-devel

%description -n %upname-devel
The libtorrent-devel package contains libraries and header files needed
to develop applications using libTorrent.

%if_enabled static
%package -n %upname-devel-static
Summary: Development static libraries for libTorrent
Group: Development/C++
Requires: %name = %epoch:%version-%release
Provides: libtorrent-rasterbar7-devel-static = %epoch:%version-%release
Conflicts: libtorrent-rasterbar7-devel-static < %epoch:%version-%release
#Conflicts: libtorrent-devel

%description -n %upname-devel-static
The libtorrent-devel package contains static libraries needed
to develop applications using libTorrent.
%endif

%package -n python-module-%upname
Summary: libTorrent python bindings
Group: Development/Python
Requires: %name = %epoch:%version-%release
Provides: python-module-libtorrent-rasterbar7 = %epoch:%version-%release
Conflicts: python-module-libtorrent-rasterbar7 < %epoch:%version-%release

%description -n python-module-%upname
The python-module-libtorrent-rasterbar contains
python bindings to libTorrent.

%prep
%setup

mkdir -p build-aux
touch build-aux/config.rpath

mv -f COPYING COPYING.orig
ln -s $(relative %_licensedir/GPL-2 %_docdir/%name/COPYING) COPYING

%build
export LDFLAGS="$LDFLAGS -L/%_lib -lrt"
%autoreconf
%configure %{subst_enable static} %{subst_enable debug} --with-boost-libdir=%_libdir \
	--enable-python-binding
%make_build V=1

%install
%makeinstall_std

rm -f %buildroot%_libdir/*.la
%if_disabled static
rm -f %buildroot%_libdir/*.a
%endif

%files
%doc AUTHORS ChangeLog NEWS README
%doc --no-dereference COPYING
%_libdir/*.so.*

%files -n %upname-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%if_enabled static
%files -n %upname-devel-static
%_libdir/*.a
%endif

%files -n python-module-%upname
%python_sitelibdir/libtorrent.so
%python_sitelibdir/*.egg-info

%changelog
