%define pkgname totem-pl-parser
%define ver_major 3.4
%def_enable gtk_doc
%def_enable introspection

Name: lib%pkgname
Version: %ver_major.5
Release: alt1

Summary: Shared libraries of the Totem media player play list parser
Group: System/Libraries
License: GPL
URL: http://www.hadess.net/%pkgname.php3

#Source: %pkgname-%version.tar
Source: ftp://ftp.gnome.org/pub/gnome/sources/%pkgname/%ver_major/%pkgname-%version.tar.xz

BuildPreReq: glib2-devel >= 2.33.10 libgio-devel >= 2.24.0
BuildRequires: gnome-common gtk-doc intltool perl-XML-Parser libgmime-devel
BuildRequires: libxml2-devel libsoup-gnome-devel libarchive-devel
BuildRequires: libgcrypt-devel libquvi-devel >= 0.2.15
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= 0.9.5}

%description
Shared libraries that come with the Totem media player.

%package devel
Summary: Development files for Totem media player play list parser
Group: Development/C
Requires: %name = %version-%release

%description devel
Totem is simple movie player for the Gnome desktop based on Xine.
This package provides files needed to build applications using Totem
libraries.

%package devel-doc
Summary: Development documentation for Totem media player play list parser
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
Totem is simple movie player for the Gnome desktop based on Xine.
This package contains documentation needed to develop applications using Totem
libraries.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Totem playlist parser library

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Totem playlist parser library

%define _libexecdir %_libdir/%name

%prep
%setup -n %pkgname-%version
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure \
	--disable-static \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable introspection}

%make_build

%install
%makeinstall

%find_lang --with-gnome --output=%name.lang %pkgname %pkgname-2.0

%files -f %name.lang
%doc AUTHORS NEWS README
%_libdir/*.so.*

%files -n %name-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%files -n %name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/*

%files gir-devel
%_datadir/gir-1.0/*
%endif

%changelog
