# -*- rpm-spec -*-

# %%branch_switch set %%branch_release use
#%%define branch_switch Mxx

%define _localstatedir /var
%define qemu_user  _libvirt
%define qemu_group  vmusers

# A client only build will create a libvirt.so only containing
# the generic RPC driver, and test driver and no libvirtd
# Default to a full server + client build

%ifarch %ix86 x86_64 ia64
%def_enable server_drivers
%else
%def_disable server_drivers
%endif

# Always build with dlopen'd modules
%def_with driver_modules

%if_enabled server_drivers
# First the daemon itself
%def_with libvirtd
%def_with avahi

# Then the hypervisor drivers that run on local host
%def_with xen
%def_with qemu
%def_with openvz
%def_with lxc
%def_with vbox
%def_without uml
%def_without libxl
%def_with vmware

# Then the hypervisor drivers that talk via a native remote protocol
%def_with phyp
%def_with esx
%def_without hyperv
%def_without xenapi


# Then the secondary host drivers
%def_with network
%def_with storage_fs
%def_with storage_lvm
%def_with storage_iscsi
%def_with storage_disk
%def_with storage_rbd
%def_with storage_mpath
%def_with numactl
%def_with selinux

# A few optional bits
%def_without netcf
%def_with udev
%def_without hal
%def_with yajl
%def_without sanlock
%def_with fuse

%endif #server_drivers

%if_with  qemu
%def_with qemu_tcg

%ifarch %ix86 x86_64
%def_with qemu_kvm
%endif
%endif

# A few optional bits
%def_with dbus
%def_with polkit
%def_with capng


%if_with qemu || lxc || uml
%def_with nwfilter
%def_with libpcap
%endif

%if_with qemu
%def_with macvtap
%def_with libnl
%endif

%def_with audit
%def_without dtrace

# Non-server/HV driver defaults which are always enabled
%def_with python
%def_with sasl

Name: libvirt
Version: 1.0.4
Release: alt2
Summary: Library providing a simple API virtualization
License: LGPLv2+
Group: System/Libraries
Url: http://libvirt.org/
Source0: %name-%version.tar
Source1: gnulib-%name-%version.tar
Patch1: %name-%version-%release.patch


%{?_with_libvirtd:Requires: libvirt-daemon = %version-%release}
%{?_with_network:Requires: libvirt-daemon-config-network = %version-%release}
%{?_with_nwfilter:Requires: libvirt-daemon-config-nwfilter = %version-%release}
%{?_with_qemu:Requires: libvirt-qemu-common = %version-%release}
Requires: libvirt-client = %version-%release

%{?_with_xen:BuildRequires: xen-devel xen-runtime}
%{?_with_hal:BuildRequires: libhal-devel}
%{?_with_udev:BuildRequires: libudev-devel libpciaccess-devel}
%{?_with_yajl:BuildRequires: libyajl-devel}
%{?_with_sanlock:BuildRequires: sanlock-devel >= 1.8}
%{?_with_libpcap:BuildRequires: libpcap-devel}
%{?_with_libnl:BuildRequires: libnl-devel}
%{?_with_avahi:BuildRequires: libavahi-devel}
%{?_with_selinux:BuildRequires: libselinux-devel}
%{?_with_network:BuildRequires: dnsmasq iptables iptables-ipv6 radvd}
%{?_with_nwfilter:BuildRequires: ebtables}
%{?_with_sasl:BuildRequires: libsasl2-devel}
%{?_with_dbus:BuildRequires: libdbus-devel >= 1.0.0}
%{?_with_polkit:BuildRequires: polkit}
%{?_with_storage_fs:BuildRequires: util-linux}
%{?_with_qemu:BuildRequires: qemu-img}
%{?_with_storage_lvm:BuildRequires: lvm2}
%{?_with_storage_disk:BuildRequires: libparted-devel parted}
%{?_with_storage_rbd:BuildRequires: ceph-devel}
%{?_with_storage_iscsi:BuildRequires: open-iscsi}
%{?_with_storage_mpath:BuildRequires: libdevmapper-devel}
%{?_with_numactl:BuildRequires: libnuma-devel}
%{?_with_capng:BuildRequires: libcap-ng-devel}
%{?_with_phyp:BuildRequires: libssh2-devel}
%{?_with_netcf:BuildRequires: netcf-devel}
%{?_with_esx:BuildRequires: libcurl-devel}
%{?_with_hyperv:BuildRequires: libwsman-devel}
%{?_with_audit:BuildRequires: libaudit-devel}
%{?_with_fuse:BuildRequires: libfuse-devel >= 2.8.6}

BuildRequires: bridge-utils libblkid-devel
BuildRequires: libgcrypt-devel libgnutls-devel
BuildRequires: libreadline-devel
BuildRequires: libtasn1-devel
BuildRequires: perl-Pod-Parser
BuildRequires: libxml2-devel xml-utils xsltproc w3c-markup-validator-libs
BuildRequires: python-devel python-module-distribute
BuildRequires: iproute2 perl-Pod-Parser

%description
Libvirt is a C toolkit to interact with the virtualization capabilities
of recent versions of Linux (and other OSes).
The main package includes the libvirtd server exporting the virtualization support.

%package docs
Summary: Documentation for libvirt library and daemon
Group: Development/Documentation
BuildArch: noarch

%description docs
Copy of the libvirt website documentation

%package daemon
Summary: Server side daemon and supporting files for libvirt library
Group: System/Servers
Requires: %name-client = %version-%release
Requires: iptables

%description daemon
Server side daemon required to manage the virtualization capabilities
of recent versions of Linux. Requires a hypervisor specific sub-RPM
for specific drivers.

%package daemon-config-network
Summary: Default configuration files for the libvirtd daemon
Group: System/Servers
BuildArch: noarch
Requires: %name-daemon = %version-%release
Requires: bridge-utils
%if_with driver_modules
Requires: %name-daemon-driver-network = %version-%release
%endif

%description daemon-config-network
Default configuration files for setting up NAT based networking

%package daemon-config-nwfilter
Summary: Network filter configuration files for the libvirtd daemon
Group: System/Servers
BuildArch: noarch
Requires: %name-daemon = %version-%release
%if_with driver_modules
Requires: %name-daemon-driver-nwfilter = %version-%release
%endif

%description daemon-config-nwfilter
Network filter configuration files for cleaning guest traffic

%if_with driver_modules
%if_with network
%package daemon-driver-network
Summary: Network driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release

%description daemon-driver-network
The network driver plugin for the libvirtd daemon, providing
an implementation of the virtual network APIs using the Linux
bridge capabilities.
%endif

%if_with nwfilter
%package daemon-driver-nwfilter
Summary: Nwfilter driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release
Requires: ebtables

%description daemon-driver-nwfilter
The nwfilter driver plugin for the libvirtd daemon, providing
an implementation of the firewall APIs using the ebtables,
iptables and ip6tables capabilities
%endif

%if_with udev
%package daemon-driver-nodedev
Summary: Nodedev driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release

%description daemon-driver-nodedev
The nodedev driver plugin for the libvirtd daemon, providing
an implementation of the node device APIs using the udev
capabilities.

%package daemon-driver-interface
Summary: Interface driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release

%description daemon-driver-interface
The interface driver plugin for the libvirtd daemon, providing
an implementation of the network interface APIs using the
netcf library or udev.
%endif

%package daemon-driver-secret
Summary: Secret driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release

%description daemon-driver-secret
The secret driver plugin for the libvirtd daemon, providing
an implementation of the secret key APIs.

%package daemon-driver-storage
Summary: Storage driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release

%description daemon-driver-storage
The storage driver plugin for the libvirtd daemon, providing
an implementation of the storage APIs using LVM, iSCSI,
parted and more.

%if_with qemu
%package daemon-driver-qemu
Summary: Qemu driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release
Requires: %name-daemon-driver-network = %version-%release

%description daemon-driver-qemu
The qemu driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
QEMU
%endif

%if_with lxc
%package daemon-driver-lxc
Summary: LXC driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release
Requires: %name-daemon-driver-network = %version-%release

%description daemon-driver-lxc
The LXC driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
the Linux kernel
%endif

%if_with uml
%package daemon-driver-uml
Summary: Uml driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release

%description daemon-driver-uml
The UML driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
User Mode Linux
%endif

%if_with xen
%package daemon-driver-xen
Summary: Xen driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release

%description daemon-driver-xen
The Xen driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
Xen
%endif


%if_with libxl
%package daemon-driver-libxl
Summary: Libxl driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon = %version-%release

%description daemon-driver-libxl
The Libxl driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
Libxl
%endif
%endif #driver_modules

%package qemu-common
Summary: Server side daemon, driver & default configs required to run QEMU or KVM guests
Group: System/Servers
BuildArch: noarch
Requires: %name-daemon-config-network = %version-%release
Requires: %name-daemon-config-nwfilter = %version-%release
Requires: %name-daemon = %version-%release
%if_with driver_modules
Requires: %name-daemon-driver-qemu = %version-%release
Requires: %name-daemon-driver-nodedev = %version-%release
Requires: %name-daemon-driver-secret = %version-%release
Requires: %name-daemon-driver-storage = %version-%release
%endif

%description qemu-common
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of QEMU or KVM.

%package qemu
Summary: Server side daemon, driver & default configs required to run QEMU guests
Group: System/Servers
BuildArch: noarch
Requires: %name-qemu-common = %version-%release
Requires: qemu

%description qemu
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of QEMU.

%package kvm
Summary: Server side daemon, driver & default configs required to run KVM guests
Group: System/Servers
BuildArch: noarch
Requires: %name-qemu-common = %version-%release
Requires: qemu-kvm

%description kvm
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of KVM.

%package lxc
Summary: Server side daemon, driver & default configs required to run LXC guests
Group: System/Servers
Requires: %name-daemon-config-network = %version-%release
Requires: %name-daemon-config-nwfilter = %version-%release
Requires: %name-daemon = %version-%release
Requires: lxc
%if_with driver_modules
Requires: %name-daemon-driver-lxc = %version-%release
Requires: %name-daemon-driver-nodedev = %version-%release
Requires: %name-daemon-driver-secret = %version-%release
Requires: %name-daemon-driver-storage = %version-%release
%endif

%description lxc
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of LXC.

%package uml
Summary: Server side daemon, driver & default configs required to run UML guests
Group: System/Servers
Requires: %name-daemon-config-network = %version-%release
Requires: %name-daemon-config-nwfilter = %version-%release
Requires: %name-daemon = %version-%release
%if_with driver_modules
Requires: %name-daemon-driver-uml = %version-%release
Requires: %name-daemon-driver-nodedev = %version-%release
Requires: %name-daemon-driver-secret = %version-%release
Requires: %name-daemon-driver-storage = %version-%release
%endif

%description uml
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of UML.

%package xen
Summary: Server side daemon, driver & default configs required to run XEN guests
Group: System/Servers
BuildArch: noarch
Requires: %name-daemon-config-network = %version-%release
Requires: %name-daemon-config-nwfilter = %version-%release
Requires: %name-daemon = %version-%release
Requires: xen
%if_with driver_modules
%if_with xen
Requires: %name-daemon-driver-xen = %version-%release
%endif
%if_with libxl
Requires: %name-daemon-driver-libxl = %version-%release
%endif
Requires: %name-daemon-driver-nodedev = %version-%release
Requires: %name-daemon-driver-secret = %version-%release
Requires: %name-daemon-driver-storage = %version-%release
%endif #driver_modules

%description xen
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of Xen.

%package client
Summary: Client side library and utilities of the libvirt library
Group: System/Libraries
# So remote clients can access libvirt over SSH tunnel
# (client invokes 'nc' against the UNIX socket on the server)
Requires: nc
# Needed by libvirt-guests init script.
Requires: gettext
# For virConnectGetSysinfo
Requires: dmidecode
# Needed by virt-pki-validate script
Requires: gnutls-utils
# Needed for probing the power management features of the host.
Requires: pm-utils
Conflicts: %name < 0.9.11

%description client
Shared libraries and client binaries needed to access to the
virtualization capabilities of recent versions of Linux (and other OSes).

%package devel
Summary: Libraries, includes, etc. to compile with the libvirt library
Group: Development/C
Requires: %name-client = %version-%release

%description devel
Includes and documentations for the C library providing an API to use
the virtualization capabilities of recent versions of Linux (and other OSes).

%package -n python-module-%name
Summary: Python bindings for the libvirt library
Group: Development/Python
Requires: %name-client = %version-%release

Obsoletes: %name-python < %version-%release
Provides: %name-python = %version-%release

%description -n python-module-%name
The libvirt-python package contains a module that permits applications
written in the Python programming language to use the interface
supplied by the libvirt library to use the virtualization capabilities
of recent versions of Linux (and other OSes).

%prep
%setup -a1
%patch1 -p1
# git and rsync aren't needed for build.
sed -i '/^\(git\|rsync\)[[:space:]]/d' bootstrap.conf
# disable virnetsockettest test
sed -i 's/virnetsockettest //' tests/Makefile.am

%build
./bootstrap --no-git --gnulib-srcdir=gnulib-%name-%version
%configure \
		--disable-static \
		--disable-rpath \
		--with-packager-version="%release" \
		--with-init-script=systemd+redhat \
		--with-qemu-user=%qemu_user \
		--with-qemu-group=%qemu_group \
		--with-xml-catalog-file=/etc/sgml/catalog \
		--with-sysctl=check \
		%{subst_with libvirtd} \
		%{subst_with avahi} \
		%{subst_with xen} \
		%{subst_with qemu} \
		%{subst_with openvz} \
		%{subst_with lxc} \
		%{subst_with vbox} \
		%{subst_with uml} \
		%{subst_with libxl} \
		%{subst_with vmware} \
		%{subst_with phyp} \
		%{subst_with esx} \
		%{subst_with hyperv} \
		%{subst_with xenapi} \
		%{subst_with network} \
		%{?_with_storage_fs:--with-storage-fs} \
		%{?_with_storage_lvm:--with-storage-lvm} \
		%{?_with_storage_iscsi:--with-storage-iscsi} \
		%{?_with_storage_disk:--with-storage-disk} \
		%{?_with_storage_rbd:--with-storage-rbd} \
		%{?_with_storage_mpath:--with-storage-mpath} \
		%{subst_with numactl} \
		%{subst_with selinux} \
		%{subst_with netcf} \
		%{subst_with udev} \
		%{subst_with hal} \
		%{subst_with yajl} \
		%{subst_with sanlock} \
		%{subst_with fuse} \
		%{subst_with dbus} \
		%{subst_with polkit} \
		%{subst_with capng} \
		%{subst_with libpcap} \
		%{subst_with macvtap} \
		%{subst_with audit} \
		%{?_with_driver_modules:--with-driver-modules} \
		%{subst_with dtrace} \
		%{subst_with python} \
		%{subst_with sasl}


%make_build
gzip -9 ChangeLog

%install
%makeinstall_std

for i in domain-events/events-c dominfo domsuspend hellolibvirt openauth python xml/nwfilter systemtap
do
  (cd examples/$i ; make clean ; rm -rf .deps .libs Makefile Makefile.in)
done

install -d -m 0755 %buildroot%_localstatedir/run/libvirt/
rm -f %buildroot%_libdir/*.{a,la}
rm -f %buildroot%_libdir/%name/*/*.{a,la}
rm -f %buildroot%_libdir/python*/site-packages/*.{a,la}

%if_with network
# We don't want to install /etc/libvirt/qemu/networks in the main %files list
# because if the admin wants to delete the default network completely, we don't
# want to end up re-incarnating it on every RPM upgrade.
install -d -m 0755 %buildroot%_datadir/libvirt/networks/
cp %buildroot%_sysconfdir/libvirt/qemu/networks/default.xml \
   %buildroot%_datadir/libvirt/networks/default.xml
rm -f %buildroot%_sysconfdir/libvirt/qemu/networks/default.xml
rm -f %buildroot%_sysconfdir/libvirt/qemu/networks/autostart/default.xml
# Strip auto-generated UUID - we need it generated per-install
sed -i -e "/<uuid>/d" %buildroot%_datadir/libvirt/networks/default.xml
%else
rm -f %buildroot%_sysconfdir/libvirt/qemu/networks/default.xml
rm -f %buildroot%_sysconfdir/libvirt/qemu/networks/autostart/default.xml
%endif

%if_without qemu
rm -f %buildroot%_datadir/augeas/lenses/libvirtd_qemu.aug
rm -f %buildroot%_datadir/augeas/lenses/tests/test_libvirtd_qemu.aug
rm -f %buildroot%_sysconfdir/libvirt/qemu.conf
rm -f %buildroot%_sysconfdir/logrotate.d/libvirtd.qemu
%endif
%if_without lxc
rm -f %buildroot%_datadir/augeas/lenses/libvirtd_lxc.aug
rm -f %buildroot%_datadir/augeas/lenses/tests/test_libvirtd_lxc.aug
rm -f %buildroot%_sysconfdir/libvirt/lxc.conf
rm -f %buildroot%_sysconfdir/logrotate.d/libvirtd.lxc
%endif
%if_without uml
rm -rf %buildroot%_sysconfdir/logrotate.d/libvirtd.uml
%endif
%if_without nwfilter
rm -rf %buildroot%_sysconfdir/libvirt/nwfilter
%endif


install -pD -m644 libvirtd.tmpfiles %buildroot/lib/tmpfiles.d/libvirtd.conf

%find_lang %name

%check
cd tests
%make
# These 1 tests don't current work
for i in daemon-conf
do
  rm -f $i
  printf "#!/bin/sh\nexit 0\n" > $i
  chmod +x $i
done
%make check

%if_with libvirtd
%pre daemon
%_sbindir/groupadd -r -f %qemu_group
%_sbindir/useradd -M -r -d %_localstatedir/lib/%name -s /bin/false -c "libvirt user" -g %qemu_group %qemu_user >/dev/null 2>&1 || :

%post daemon
if [ $1 -eq 1 ]; then
    if ! grep -q ^host_uuid /etc/libvirt/libvirtd.conf ; then
	UUID2=`/usr/bin/uuidgen`
	echo host_uuid = \"$UUID2\" >> /etc/libvirt/libvirtd.conf
    fi
fi
%post_service libvirtd
%post_service virtlockd

%preun daemon
%preun_service libvirtd
%preun_service virtlockd

%if_with network
%post daemon-config-network
if [ $1 -eq 1 ]; then
    if [ ! -f %_sysconfdir/libvirt/qemu/networks/default.xml ]; then
	UUID=`/usr/bin/uuidgen`
	sed -e "s,</name>,</name>\n  <uuid>$UUID</uuid>," \
         < %_datadir/libvirt/networks/default.xml \
         > /etc/libvirt/qemu/networks/default.xml
	ln -s ../default.xml /etc/libvirt/qemu/networks/autostart/default.xml
    fi
fi
%endif
%endif

%post client
%post_service libvirt-guests

%preun client
%preun_service libvirt-guests

%files

%files docs
%doc docs/*.xml
%doc %_datadir/gtk-doc/html/libvirt
%doc examples

%doc docs/html docs/devhelp docs/*.gif
%doc docs/libvirt-api.xml

%files client -f %name.lang
%doc AUTHORS ChangeLog.gz README COPYING.LIB TODO
%_libdir/lib*.so.*

%config(noreplace) %_sysconfdir/libvirt/libvirt.conf
%_bindir/virsh
%_bindir/virt-xml-validate
%_bindir/virt-pki-validate
%_bindir/virt-host-validate
%_man1dir/virsh.*
%_man1dir/virt-xml-validate.*
%_man1dir/virt-pki-validate.*
%_man1dir/virt-host-validate.*
%dir %_datadir/libvirt
%dir %_datadir/libvirt/schemas
%_datadir/libvirt/schemas/*.rng
%_datadir/libvirt/cpu_map.xml

%if_with sasl
%config(noreplace) %_sysconfdir/sasl2/libvirt.conf
%endif

%config(noreplace) %_sysconfdir/sysconfig/libvirt-guests
%_initdir/libvirt-guests
%_libexecdir/libvirt-guests.sh
%systemd_unitdir/libvirt-guests.service

%dir %_localstatedir/lib/libvirt

%if_with libvirtd
%files daemon
%dir %attr(0700, root, root) %_sysconfdir/libvirt
%dir %_datadir/libvirt
%dir %attr(0700, root, root) %_localstatedir/log/libvirt
%dir %_localstatedir/run/libvirt
%dir %attr(0700, root, root) %_sysconfdir/libvirt/nwfilter
%config(noreplace) %_sysconfdir/sysconfig/libvirtd
%config /lib/tmpfiles.d/libvirtd.conf
%_unitdir/libvirtd.service
%_initdir/libvirtd
%config(noreplace) %_sysconfdir/libvirt/libvirtd.conf
/lib/sysctl.d/*
%config(noreplace) %_sysconfdir/logrotate.d/libvirtd

#virtlockd
%config(noreplace) %_sysconfdir/libvirt/qemu-lockd.conf
%_initdir/virtlockd
%config(noreplace) %_sysconfdir/sysconfig/virtlockd
%_unitdir/virtlockd.service
%_unitdir/virtlockd.socket
%_libdir/%name/lock-driver/lockd.so
%_sbindir/virtlockd
%_datadir/augeas/lenses/libvirt_lockd.aug
%_datadir/augeas/lenses/tests/test_libvirt_lockd.aug

%if_with storage_disk
%_libexecdir/libvirt_parthelper
%endif

%_libexecdir/libvirt_iohelper
%_sbindir/libvirtd
%_man8dir/libvirtd.*

%_datadir/augeas/lenses/libvirtd.aug
%_datadir/augeas/lenses/tests/test_libvirtd.aug

%dir %attr(0711, root, root) %_localstatedir/lib/libvirt/images
%dir %attr(0711, root, root) %_localstatedir/lib/libvirt/filesystems
%dir %attr(0711, root, root) %_localstatedir/lib/libvirt/boot
%dir %attr(0700, root, root) %_localstatedir/cache/libvirt

%if_with polkit
%_datadir/polkit-1/actions/org.libvirt.unix.policy
%endif

%if_with network
%files daemon-config-network
%dir %attr(0700, root, root) %_sysconfdir/libvirt/qemu
%dir %attr(0700, root, root) %_sysconfdir/libvirt/qemu/networks
%dir %attr(0700, root, root) %_sysconfdir/libvirt/qemu/networks/autostart
%dir %_datadir/libvirt/networks
%_datadir/libvirt/networks/default.xml
%dir %_localstatedir/run/libvirt/network
%dir %attr(0700, root, root) %_localstatedir/lib/libvirt/network
%dir %attr(0755, root, root) %_localstatedir/lib/libvirt/dnsmasq
%endif

%if_with nwfilter
%files daemon-config-nwfilter
%_sysconfdir/libvirt/nwfilter/*.xml
%endif

%if_with driver_modules
%if_with network
%files daemon-driver-network
%_libdir/%name/connection-driver/libvirt_driver_network.so
%endif

%if_with udev
%files daemon-driver-nodedev
%_libdir/%name/connection-driver/libvirt_driver_nodedev.so

%files daemon-driver-interface
%_libdir/%name/connection-driver/libvirt_driver_interface.so
%endif

%if_with nwfilter
%files daemon-driver-nwfilter
%_libdir/%name/connection-driver/libvirt_driver_nwfilter.so
%endif

%files daemon-driver-secret
%_libdir/%name/connection-driver/libvirt_driver_secret.so

%files daemon-driver-storage
%_libdir/%name/connection-driver/libvirt_driver_storage.so
%endif

%if_with qemu
%files daemon-driver-qemu
%_libdir/%name/connection-driver/libvirt_driver_qemu.so
%endif

%if_with lxc
%files daemon-driver-lxc
%_libdir/%name/connection-driver/libvirt_driver_lxc.so
%endif

%if_with uml
%files daemon-driver-uml
%_libdir/%name/connection-driver/libvirt_driver_uml.so
%endif

%if_with xen
%files daemon-driver-xen
%_libdir/%name/connection-driver/libvirt_driver_xen.so
%endif

%if_with libxl
%files daemon-driver-libxl
%_libdir/%name/connection-driver/libvirt_driver_libxl.so
%endif
%endif #driver_modules

%if_with qemu
%files qemu-common
%config(noreplace) %_sysconfdir/libvirt/qemu.conf
%config(noreplace) %_sysconfdir/logrotate.d/libvirtd.qemu
%dir %attr(0700, root, root) %_localstatedir/run/libvirt/qemu
%dir %attr(0750, %qemu_user, %qemu_group) %_localstatedir/lib/libvirt/qemu
%dir %attr(0750, %qemu_user, %qemu_group) %_localstatedir/cache/libvirt/qemu
%dir %attr(0700, root, root) %_localstatedir/log/libvirt/qemu
%_datadir/augeas/lenses/libvirtd_qemu.aug
%_datadir/augeas/lenses/tests/test_libvirtd_qemu.aug

%if_with qemu_tcg
%files qemu
%endif
%if_with qemu_kvm
%files kvm
%endif

%endif #qemu

%if_with lxc
%files lxc
%config(noreplace) %_sysconfdir/libvirt/lxc.conf
%config(noreplace) %_sysconfdir/logrotate.d/libvirtd.lxc
%dir %_localstatedir/run/libvirt/lxc
%dir %attr(0700, root, root) %_localstatedir/lib/libvirt/lxc
%dir %attr(0700, root, root) %_localstatedir/log/libvirt/lxc
%_datadir/augeas/lenses/libvirtd_lxc.aug
%_datadir/augeas/lenses/tests/test_libvirtd_lxc.aug
%_libexecdir/libvirt_lxc
%endif

%if_with uml
%files uml
%config(noreplace) %_sysconfdir/logrotate.d/libvirtd.uml
%dir %_localstatedir/run/libvirt/uml
%dir %attr(0700, root, root) %_localstatedir/lib/libvirt/uml
%dir %attr(0700, root, root) %_localstatedir/log/libvirt/uml
%endif

%if_with xen
%files xen
%if_with libxl
%dir %attr(0700, root, root) %_localstatedir/log/libvirt/libxl
%dir %attr(0700, root, root) %_localstatedir/lib/libvirt/libxl
%endif

%endif #if_with libvirtd

%files devel
%_pkgconfigdir/libvirt.pc
%_libdir/lib*.so
%_includedir/libvirt
%dir %_datadir/libvirt/api
%_datadir/libvirt/api/libvirt-api.xml
%_datadir/libvirt/api/libvirt-qemu-api.xml

%files -n python-module-%name
%python_sitelibdir/libvirt*
%doc python/tests/*.py
%doc python/TODO
%doc examples/python

%changelog
