Name: libvorbis
Version: 1.3.3
Release: alt1

Summary: The Vorbis General Audio Compression Codec
Summary(ru_RU.UTF-8): Аудиокодек Vorbis
License: BSD-style
Group: System/Libraries
Url: http://www.xiph.org/vorbis/
# http://downloads.xiph.org/releases/vorbis/%name-%version.tar.bz2
Source: %name-%version.tar
Patch1: libvorbis-1.3.2-alt-export-symbols.patch
Patch2: libvorbis-1.3.2-alt-add-needed.patch
Patch3: libvorbis-1.3.3-alt-aclocal.patch

BuildRequires: libogg-devel

%def_disable static

%description
Ogg Vorbis is a fully open, non-proprietary, patent-and-royalty-free,
general-purpose compressed audio format for audio and music at fixed
and variable bitrates from 16 to 128 kbps/channel.

%description -l ru_RU.UTF-8
Ogg Vorbis - это полностью открытый и свободный формат для сжатия звука.

%package devel
Summary: Development files for libvorbis
Group: Development/C
PreReq: %name = %version-%release
Requires: libogg-devel

%description devel
The libvorbis-devel package contains the header files and documentation
needed to develop applications with libvorbis.

%description devel -l ru_RU.UTF-8
В этом пакете находятся файлы, необходимые для использования libvorbis
в разработке приложений.

%package devel-static
Summary: Static libraries for libvorbis
Group: Development/C
PreReq: %name-devel = %version-%release
Requires: libogg-devel-static

%description devel-static
This package contains development libraries required for packaging
statically linked libvorbis-based software.

%description devel-static -l ru_RU.UTF-8
В этом пакете находятся статические библиотеки, необходимые
для использования libvorbis в разработке статических приложений.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
for f in m4/*.m4; do
	[ ! -f "%_datadir/aclocal/${f##*/}" ] ||
		rm -fv "$f"
done
# restrict lists of global symbols exported by libraries
sed -n 's/^extern[[:space:]]\+[^(]*[[:space:]]\**\([a-z][^()[:space:]]\+\)[[:space:]]*(.*/\1/p' \
	include/vorbis/*.h > lib/libvorbis.sym
# extra symbols required by packages
cat >> lib/libvorbis.sym <<'EOF'
vorbis_window
_ilog
EOF
sort -u -o lib/libvorbis.sym{,}

%build
%autoreconf
%configure %{subst_enable static}
%make_build

%install
%makeinstall_std
%define docdir %_docdir/%name-%version
install -pm644 AUTHORS CHANGES COPYING %buildroot%docdir/
%set_verify_elf_method strict

%check
%make_build -k check

%files
%_libdir/*.so.*
%dir %docdir
%docdir/[A-Z]*

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_datadir/aclocal/*
%dir %docdir
%docdir/[a-z]*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
