%ifarch %ix86
%define platform x86-linux-gcc
%else
%ifarch arm
%define platform armv5te-linux-gcc
%else
%ifarch armh
%define platform armv7-linux-gcc
%else
%define platform %_arch-linux-gcc
%endif
%endif
%endif

Name: libvpx
Version: 1.3.0
Release: alt1.M70P.1
Summary: VP8 video codec
Group: Video
License: BSD
Url: http://www.webmproject.org/

Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source0: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: doxygen
%ifarch %ix86 x86_64
BuildRequires: yasm
%endif

%description
VP8 is an open video codec, originally developed by On2 and released
as open source by Google Inc. It is the successor of the VP3 codec,
on which the Theora codec was based

%prep
%setup -q
%patch -p1
%ifarch armh
sed -i -e 's,softfp,hard,' build/make/configure.sh
%endif

%build
%ifarch %ix86 x86_64 %arm
export CFLAGS="$RPM_OPT_FLAGS -fPIC"
%endif
sed -i '/AVX/d' vp9/vp9_common.mk
./configure \
	--prefix=%prefix \
	--libdir=%_libdir \
	--enable-pic \
	--target=%platform \
	--enable-shared \
	--disable-avx \
	--disable-avx2
%make_build

%install
%make DESTDIR=%buildroot install

%files
%doc AUTHORS LICENSE PATENTS CHANGELOG
%_libdir/*.so.*

%changelog
