%set_verify_elf_method textrel=relaxed
%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_prefix/libexec
%add_verify_elf_skiplist %_libexecdir/WebKitPluginProcess
%define gtk_ver 3.0

%define oname webkit
%define _name webkitgtk

# none/opengl/cairo/clutter
%define acceleration_backend opengl
%def_enable introspection
%def_enable geolocation
%def_disable web_audio
%def_disable media_stream
%def_enable spellcheck
%def_enable webkit2

Summary: Web browser engine
Name: libwebkitgtk3
Version: 2.0.4
Release: alt1
License: %bsd %lgpl2plus
Group: System/Libraries
Url: http://www.webkitgtk.org/
Source: %_name-%version.tar.xz
Source1: webkit_symbols.filter

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Requires: libjavascriptcoregtk3 = %version-%release
BuildPreReq: rpm-build-licenses

BuildRequires: gcc-c++ libicu-devel bison perl-Switch zlib-devel

BuildRequires: flex >= 2.5.33
BuildRequires: gperf libjpeg-devel libpng-devel libwebp-devel
BuildRequires: libxml2-devel >= 2.6
BuildRequires: libXt-devel
BuildRequires: libgtk+3-devel >= 3.4.0
BuildRequires: libgail3-devel >= 3.0
BuildRequires: libenchant-devel >= 0.22
BuildRequires: libsqlite3-devel >= 3.0
BuildRequires: libxslt-devel >= 1.1.7
BuildRequires: gstreamer1.0-devel >= 1.0.3 gst-plugins1.0-devel >= 1.0.3
BuildRequires: librsvg-devel >= 2.2.0
BuildRequires: gtk-doc >= 1.10
BuildRequires: libsoup-devel >= 2.40.0
BuildRequires: libsecret-devel
BuildRequires: libpango-devel >= 1.21.0 libcairo-devel >= 1.10 libcairo-gobject-devel
BuildRequires: fontconfig-devel >= 2.4 libfreetype-devel libharfbuzz-devel
BuildRequires: libgio-devel >= 2.25.0
BuildRequires: python-modules-json
BuildRequires: ruby ruby-stdlibs


%if %acceleration_backend == opengl
BuildRequires: libGL-devel libXcomposite-devel libXdamage-devel
%endif

%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= 0.9.5 libgtk+3-gir-devel libsoup-gir-devel}
%{?_enable_geolocation:BuildPreReq: libgeoclue-devel}
%{?_enable_spellcheck:BuildPreReq: libenchant-devel}
%{?_enable_webkit2:BuildPreReq: libat-spi2-core-devel >= 2.2.1  libgtk+2-devel libgail-devel}
%{?_enable_media_stream:BuildPreReq: farstream0.2-devel}

# for check
BuildRequires: xvfb-run python-module-pygobject3

%description
WebKit is an open source web browser engine.
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux.

%package devel
Summary: Development files for WebKit GTK+ port
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Requires: libjavascriptcoregtk3-devel = %version-%release

%description devel
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux. This package contains development headers.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version-%release

%description devel-doc
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux.

This package provides development documentation for %name.

%package -n libjavascriptcoregtk3
Summary: GTK+3 version of the JavaScriptCore engine
Group: System/Libraries

%description -n libjavascriptcoregtk3
This package provides GTK+3 version of the JavaScriptCore engine from
WebKit package.

%package -n libjavascriptcoregtk3-devel
Summary: Development files for JavaScriptCore library
Group: Development/GNOME and GTK+
Requires: libjavascriptcoregtk3 = %version-%release

%description -n libjavascriptcoregtk3-devel
This package provides development files for GTK+3 version of the
JavaScriptCore engine.

%package -n libwebkit2gtk
Summary: WebKit2 is a new API layer for WebKit
Group: System/Libraries
Requires: libjavascriptcoregtk3 = %version-%release

%description -n libwebkit2gtk
WebKit2 is a new API layer for WebKit designed from the ground up to support a split process model,
where the web content (JavaScript, HTML, layout, etc) lives in a separate process from the application UI.
This model is very similar to what Google Chrome offers, with the major difference being
that we have built the process split model directly into the framework, allowing other clients of WebKit to use it.

%package -n libwebkit2gtk-devel
Summary: WebKit2 is a new API layer for WebKit
Group: Development/GNOME and GTK+
Requires: libwebkitgtk3-devel = %version-%release
Requires: libjavascriptcoregtk3-devel = %version-%release
Requires: libwebkit2gtk = %version-%release

%description -n libwebkit2gtk-devel
WebKit2 is a new API layer for WebKit designed from the ground up to support a split process model,
where the web content (JavaScript, HTML, layout, etc) lives in a separate process from the application UI.
This model is very similar to what Google Chrome offers, with the major difference being
that we have built the process split model directly into the framework, allowing other clients of WebKit to use it.


%package jsc
Summary: JavaScriptCore shell for WebKit GTK+
Group: Development/GNOME and GTK+
Requires: libjavascriptcoregtk3 = %version-%release

%description jsc
jsc is a shell for JavaScriptCore, WebKit's JavaScript engine. It
allows you to interact with the JavaScript engine directly.

%package webinspector
Summary: Data files for WebKit GTK+'s Web Inspector
Group: Development/GNOME and GTK+
BuildArch: noarch

%description webinspector
WebKit GTK+ has a feature called the Web Inspector, which allows
detailed analysis of any given page's page source, live DOM hierarchy
and resources. This package contains the data files necessary for Web
Inspector to work.

%package gir
Summary: GObject introspection data for the WebkitGTK library
Group: System/Libraries
Requires: %name = %version-%release
Requires: libjavascriptcoregtk3 = %version-%release
Requires: libjavascriptcoregtk3-gir  = %version-%release

%description gir
GObject introspection data for the WebkitGTK library

%package gir-devel
Summary: GObject introspection devel data for the WebkitGTK library
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: libjavascriptcoregtk3-gir = %version-%release
Requires: libjavascriptcoregtk3-devel = %version-%release
Requires: libjavascriptcoregtk3-gir-devel = %version-%release

%description gir-devel
GObject introspection devel data for the WebkitGTK library

%package -n libjavascriptcoregtk3-gir
Summary: GObject introspection data for the JavaScriptCore library
Group: System/Libraries
Requires: libjavascriptcoregtk3 = %version-%release

%description -n libjavascriptcoregtk3-gir
GObject introspection data for the JavaScriptCore library

%package -n libjavascriptcoregtk3-gir-devel
Summary: GObject introspection devel data for the JavaScriptCore library
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: libjavascriptcoregtk3-gir = %version-%release
Requires: libjavascriptcoregtk3-devel = %version-%release

%description -n libjavascriptcoregtk3-gir-devel
GObject introspection devel data for the JavaScriptCore library

%package -n libwebkit2gtk-gir
Summary: GObject introspection data for the Webkit2 library
Group: System/Libraries
Requires: libwebkit2gtk = %version-%release

%description -n libwebkit2gtk-gir
GObject introspection data for the Webkit2 library

%package -n libwebkit2gtk-gir-devel
Summary: GObject introspection data for the Webkit2 library
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: libwebkit2gtk-gir = %version-%release
Requires: libwebkit2gtk-devel = %version-%release

%description -n libwebkit2gtk-gir-devel
GObject introspection data for the Webkit2 library

%prep
%setup -q -n %_name-%version
cp %SOURCE1 Source/autotools/symbols.filter

# fix build translations
%__subst 's|^all-local:|all-local: stamp-po|' GNUmakefile.am
rm -f Source/autotools/{compile,config.guess,config.sub,depcomp,install-sh,ltmain.sh,missing,libtool.m4,ltoptions.m4,ltsugar.m4,ltversion.m4,lt~obsolete.m4,gsettings.m4,gtk-doc.m4}

%build
%ifarch %arm ppc
# Use linker flags to reduce memory consumption on low-mem architectures
%add_optflags -Wl,--no-keep-memory -Wl,--reduce-memory-overheads
%endif

# Build with -g1 on all platforms to avoid running into 4 GB ar format limit
# https://bugs.webkit.org/show_bug.cgi?id=91154
%define optflags_debug -g1

echo "GTK_DOC_CHECK([1.10])" >> configure.ac
gtkdocize --copy
%autoreconf -I Source/autotools

%configure \
	--enable-video \
	--with-acceleration-backend=%acceleration_backend \
	--enable-webgl \
	%{subst_enable introspection} \
	%{subst_enable geolocation} \
	%{?_enable_web_audio:--enable-web-audio} \
	%{?_enable_media_stream:--enable-media-stream} \
	%{subst_enable webkit2} \
	--with-gtk=%gtk_ver

mkdir -p DerivedSources/webkit
mkdir -p DerivedSources/ANGLE
mkdir -p DerivedSources/WebKit2/webkit2gtk/webkit2
mkdir -p DerivedSources/InjectedBundle
mkdir -p DerivedSources/webkitdom
mkdir -p Programs/resources

%make_build

%install
%make_install DESTDIR=%buildroot install
%find_lang WebKitGTK-3.0

%check
xvfb-run make check

%files -f WebKitGTK-3.0.lang
%_libdir/libwebkitgtk-3.0.so.*
%dir %_datadir/webkitgtk-3.0
%_datadir/webkitgtk-3.0/images
%_datadir/webkitgtk-3.0/resources

%files devel
%_libdir/libwebkitgtk-3.0.so
%dir %_includedir/webkitgtk-3.0
%_includedir/webkitgtk-3.0/webkit
%_includedir/webkitgtk-3.0/webkitdom
%_pkgconfigdir/webkitgtk-3.0.pc

%files devel-doc
%_gtk_docdir/*

%files -n libjavascriptcoregtk3
%_libdir/libjavascriptcoregtk-3.0.so.*

%files -n libjavascriptcoregtk3-devel
%_includedir/webkitgtk-3.0/JavaScriptCore
%_libdir/libjavascriptcoregtk-3.0.so
%_pkgconfigdir/javascriptcoregtk-3.0.pc

%if_enabled webkit2
%files -n libwebkit2gtk
%_libdir/libwebkit2gtk-3.0.so.*
%_libexecdir/WebKitPluginProcess
%_libexecdir/WebKitWebProcess
%_libdir/webkit2gtk-3.0

%files -n libwebkit2gtk-devel
%_libdir/libwebkit2gtk-3.0.so
%_includedir/webkitgtk-3.0/webkit2
%_pkgconfigdir/webkit2gtk-3.0.pc

%files -n libwebkit2gtk-gir
%_typelibdir/WebKit2-3.0.typelib

%files -n libwebkit2gtk-gir-devel
%_girdir/WebKit2-3.0.gir
%endif

%files jsc
%_bindir/jsc*

%files webinspector
%_datadir/webkitgtk-3.0/webinspector

%if_enabled introspection
%files gir
%_typelibdir/WebKit-3.0.typelib

%files gir-devel
%_girdir/WebKit-3.0.gir

%files -n libjavascriptcoregtk3-gir
%_typelibdir/JSCore-3.0.typelib

%files -n libjavascriptcoregtk3-gir-devel
%_girdir/JSCore-3.0.gir
%endif

%changelog
