%define _unpackaged_files_terminate_build 1
%def_enable libwebpmux
%def_enable libwebpdemux
%def_enable libwebpdecoder
%define soversion 5

Name: libwebp
Version: 0.4.0
Release: alt2.2

Summary: Library and tools for the WebP graphics format
License: BSD
Group: System/Libraries

URL: http://webmproject.org/
Source: http://webp.googlecode.com/files/%name-%version.tar.gz
# init only
Patch: %name-0.4.0-alt-lfs.patch

BuildRequires: libjpeg-devel libpng-devel libtiff-devel libgif-devel
BuildRequires: libfreeglut-devel

%description
WebP is an image format that does lossy compression of digital
photographic images. WebP consists of a codec based on VP8, and a
container based on RIFF. Webmasters, web developers and browser
developers can use WebP to compress, archive and distribute digital
images more efficiently.

%package -n %name%soversion
Summary: Libraries for the WebP graphics format
Group: System/Libraries
Provides: %name = %version-%release
Obsoletes: libwebp = 0.4.0-alt1

%description -n %name%soversion
WebP is an image format that does lossy compression of digital
photographic images. WebP consists of a codec based on VP8, and a
container based on RIFF. Webmasters, web developers and browser
developers can use WebP to compress, archive and distribute digital
images more efficiently.

%package devel
Summary: Development files for libwebp, a library for the WebP format
Group: Development/C
Requires: %name%soversion = %version-%release

%description devel
WebP is an image format that does lossy compression of digital
photographic images. WebP consists of a codec based on VP8, and a
container based on RIFF. Webmasters, web developers and browser
developers can use WebP to compress, archive and distribute digital
images more efficiently.

%package tools
Summary: The WebP command line tools
Group: System/Libraries
Requires: %name%soversion = %version-%release

%description tools
WebP is an image format that does lossy compression of digital
photographic images. WebP consists of a codec based on VP8, and a
container based on RIFF. Webmasters, web developers and browser
developers can use WebP to compress, archive and distribute digital
images more efficiently.

%prep
%setup
%patch -b .lfs

%build
%autoreconf
%configure --disable-static \
	%{subst_enable libwebpmux} \
	%{subst_enable libwebpdemux} \
	%{subst_enable libwebpdecoder}
%make_build

%install
%makeinstall_std

%files -n %name%soversion
%_libdir/%name.so.*
%{?_enable_libwebpmux:%_libdir/%{name}mux.so.*}
%{?_enable_libwebpdemux:%_libdir/%{name}demux.so.*}
%{?_enable_libwebpdecoder:%_libdir/%{name}decoder.so.*}

%files devel
%dir %_includedir/webp
%_includedir/webp/decode.h
%_includedir/webp/encode.h
%_includedir/webp/types.h
%if_enabled libwebpmux
%_includedir/webp/mux.h
%_includedir/webp/mux_types.h
%endif
%{?_enable_libwebpdemux:%_includedir/webp/demux.h}
%_libdir/%name.so
%{?_enable_libwebpmux:%_libdir/%{name}mux.so}
%{?_enable_libwebpdemux:%_libdir/%{name}demux.so}
%{?_enable_libwebpdecoder:%_libdir/%{name}decoder.so}
%_pkgconfigdir/%name.pc
%{?_enable_libwebpmux:%_pkgconfigdir/%{name}mux.pc}
%{?_enable_libwebpdemux:%_pkgconfigdir/%{name}demux.pc}
%{?_enable_libwebpdecoder:%_pkgconfigdir/%{name}decoder.pc}

%files tools
%_bindir/cwebp
%_bindir/dwebp
%_man1dir/cwebp.1.*
%_man1dir/dwebp.1.*

%if_enabled libwebpmux
%_bindir/gif2webp
%_bindir/webpmux
%_man1dir/gif2webp.1.*
%_man1dir/webpmux.1.*
%endif
%{?_enable_libwebpdemux:%_bindir/vwebp}

%changelog
