%define major 0.2
Name: libwpg
Version: %major.2
Release: alt3

Summary: Library for importing and converting Corel WordPerfect(tm) Graphics images

Group: System/Libraries
License: LGPL
Url: http://libwpg.sf.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://prdownloads.sf.net/libwpg/%name-%version.tar

Provides: libwpg2 = %version-%release
Obsoletes: libwpg2

# Automatically added by buildreq on Sat Jan 21 2012
# optimized out: libstdc++-devel pkg-config
BuildRequires: doxygen gcc-c++ glibc-devel libwpd9-devel

%description
libwpg is a library for reading and converting WPG images

%package tools
Requires: %name = %version-%release
Summary: Tools to convert WPG images into other formats
Group: Office

%description tools
Tools to convert WPG images into other formats.
Currently supported: raw svg

%package devel
Requires: %name = %version-%release
Requires: libwpd9-devel >= 0.9.0
Summary: Files for developing with libwpg
Group: Development/C
Provides: libwpg2-devel = %version-%release
Obsoletes: libwpg2-devel

%description devel
Includes and definitions for developing with libwpg.

%package docs
Requires: %name = %version-%release
BuildRequires: doxygen
Summary: Documentation of libwpg API
Group: Documentation
BuildArch: noarch

%description docs
Documentation of libwpg API for developing with libwpg

%prep
%setup

%build
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' configure
%configure --disable-static

%make_build

%install
%makeinstall_std

rm -rf %buildroot%_libdir/libwpg*.la
#rm -rf %buildroot $RPM_BUILD_DIR/file.list.%name

%files
%_libdir/libwpg*.so.*
%doc ChangeLog README AUTHORS

%files tools
%_bindir/wpg2*

%files devel
%_libdir/libwpg*.so
%_pkgconfigdir/libwpg*.pc
%_includedir/libwpg-%major/

%files docs
%doc %_docdir/%name/

%changelog
