%define _name xfconf

%def_with perl

Name: lib%_name
Version: 4.10.0
Release: alt2

Summary: Hierarchical configuration system for Xfce
Summary (ru_RU.UTF-8): Система конфигурации Xfce
License: %gpl2only
Group: Graphical desktop/XFce
Url: http://www.xfce.org/
Packager: XFCE Team <xfce@packages.altlinux.org>

# Upstream: git://git.xfce.org/xfce/xfconf
Source: %_name-%version.tar
Patch: %_name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

Requires: dbus-tools-gui
BuildPreReq: rpm-build-xfce4 libxfce4util-devel xfce4-dev-tools
%if_with perl
BuildPreReq: rpm-build-perl perl-devel perl-ExtUtils-Depends perl-ExtUtils-PkgConfig perl-Glib-devel
%endif
BuildRequires: gtk-doc libdbus-glib-devel intltool

%description
Xfconf is a hierarchical (tree-like) configuration system where the
immediate child nodes of the root are called "channels".  All settings
beneath the channel nodes are called "properties".

%package devel
Summary: Development files for %name
Group: Development/C
PreReq: %name = %version-%release

%description devel
Header files for the %name library.

%package -n %_name-utils
Summary: Utils for xfce 4.6 configuration system
Group: Graphical desktop/XFce
PreReq: %name = %version-%release

%description -n %_name-utils
Xfconfd is a small daemon that handles storage and retrieval of settings, as well
as notifying interested applications about changes to settings. It doesn't require
a GUI, so it could even be used for command-line applications.

Xfconf-query might be one of the tools many users have been waiting on for years,
especially those hanging around in our IRC channel. Instead of having to guide new
users through several dialogs and windows, it is now possible to have every control
over your Xfce desktop at your fingertips. You can view or change any setting stored
in xfconf with xfconf-query.

%if_with perl
%package -n perl-%_name
Summary:        Perl modules for xfconf
Group:          Development/Perl
Requires:       %name = %version-%release

%description -n perl-%_name
This package includes the perl modules and files you will need to
interact with xfconf using perl.
%endif

%prep
%setup -n %_name-%version
%patch -p1

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--with-perl-options=INSTALLDIRS="vendor" \
	--enable-gtk-doc \
	--enable-debug=no
%make_build

%install
mkdir -p %buildroot/%_sysconfdir/xdg/xfce4/xfconf/xfce-perchannel-xml

%makeinstall_std
%find_lang %_name

%files -f %_name.lang
%doc AUTHORS NEWS
%_sysconfdir/xdg/xfce4/xfconf
%_libdir/*.so.*

%files devel
%doc %_datadir/gtk-doc/html/%_name
%_includedir/xfce4/xfconf-0
%_pkgconfigdir/*.pc
%_libdir/*.so

%files -n %_name-utils
%_bindir/*
%_libdir/xfce4/xfconf/
%_datadir/dbus-1/services/*.service

%if_with perl
%files -n perl-%_name
%perl_vendor_autolib/Xfce4*
%perl_vendor_archlib/Xfce4*
%endif

%changelog
