%define ver_major 5.3
%define api_ver 1.0

%def_disable static
%def_enable introspection

Name: libxklavier
Version: %ver_major
Release: alt1

Summary: libXklavier library
License: %lgpl2plus
Group: System/Libraries
Url: http://www.freedesktop.org/wiki/Software/LibXklavier
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

# From configure.in
%define libxml_ver 2.0.0
%define glib_ver 2.16.0

BuildPreReq: rpm-build-licenses
BuildPreReq: rpm-build-gnome

# From configure.in
BuildPreReq: gtk-doc libX11-devel libxkbfile-devel
BuildPreReq: libxml2-devel >= %libxml_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: iso-codes-devel libX11-devel
BuildPreReq: xkbcomp libXi-devel >= 1.1.3
%{?_enable_introspection:BuildRequires:gobject-introspection-devel}

%description
This library allows you simplify XKB-related development.

%package devel
Summary: Libraries, includes, etc to develop libxklavier applications
Group: Development/C
Requires: %name = %version-%release

%description devel
Libraries, include files, etc you can use to develop libxklavier applications.

%package devel-doc
Summary: Development documentation for libxklavier
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package contains documentation for libxklavier

%package gir
Summary: GObject introspection data for libxklavier
Group: System/Libraries
Requires: %name = %version-%release

%description gir
This package provides GObject introspection data for the libxklavier.

%package gir-devel
Summary: GObject introspection devel data for libxklavier
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
This package provides GObject introspection devel data for libxklavier.

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q

%build
%autoreconf
%configure \
	%{subst_enable static} \
	--enable-xkb-support \
	--enable-xmodmap-support \
	--with-xkb-base=%_datadir/X11/xkb \
	--with-xkb-bin-base=%_bindir \
	--with-xmodmap-base=%_datadir/xmodmap

%make_build

%install
%make_install DESTDIR=%buildroot install

%files
%_libdir/*.so.*
%doc AUTHORS CREDITS NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files devel-doc
%_gtk_docdir/%name

%files gir
%_typelibdir/Xkl-%api_ver.typelib

%files gir-devel
%_girdir/Xkl-%api_ver.gir

%changelog
