Name: libxml2
Version: 2.9.0
Release: alt1
Epoch: 1

Summary: The library for manipulating XML files
License: MIT
Group: System/Libraries
Url: http://xmlsoft.org/

%def_disable static
%define srcname libxml2-v2.9.0-42-gf7aeda2

Source: %srcname.tar
# http://www.w3.org/XML/Test/xmlts20080827.tar.gz
Source1: xmlts.tar
Patch: libxml2-%version-%release.patch

Requires: xml-common

# Automatically added by buildreq on Sun Feb 27 2011
BuildRequires: liblzma-devel python-devel python-modules-compiler python-modules-xml zlib-devel

%package devel
Summary: Development environment for building applications manipulating XML files
Group: Development/C
Requires: %name = %epoch:%version-%release

%package devel-static
Summary: Static library for building applications manipulating XML files
Group: Development/C
Requires: %name-devel = %epoch:%version-%release

%package -n xml-utils
Summary: Various XML utilities
Group: Text tools
Requires: %name = %epoch:%version-%release
Provides: xmllint = %epoch:%version
Obsoletes: xmllint < %epoch:%version

%package -n python-module-%name
Summary: Python bindings for the %name library
Group: Development/Python
Requires: %name = %epoch:%version-%release
Provides: libxml2-python = %epoch:%version, python-modules-%name = %epoch:%version
Obsoletes: libxml2-python < %epoch:%version, python-modules-%name < %epoch:%version

%package doc
Summary: Documentation for the %name library
Group: Development/C
Conflicts: %name < %epoch:%version, %name > %epoch:%version
BuildArch: noarch

%description
This library allows to manipulate XML files.  It includes support
to read, modify and write XML and HTML files.  There is DTDs support
this includes parsing and validation even with complex DtDs, either
at parse time or later once the document has been modified.  The output
can be a simple SAX stream or and in-memory DOM like representations.
In this case one can use the built-in XPath and XPointer implementation
to select subnodes or ranges.  A flexible Input/Output mechanism is
available, with existing HTTP and FTP modules and combined to an
URI library.

This package contains the shared library required to run
applications manipulating XML files.

%description devel
This library allows to manipulate XML files.  It includes support
to read, modify and write XML and HTML files.  There is DTDs support
this includes parsing and validation even with complex DtDs, either
at parse time or later once the document has been modified.  The output
can be a simple SAX stream or and in-memory DOM like representations.
In this case one can use the built-in XPath and XPointer implementation
to select subnodes or ranges.  A flexible Input/Output mechanism is
available, with existing HTTP and FTP modules and combined to an
URI library.

This package contains the libraries, include and other files
you can use to develop applications manipulating XML files.

%description devel-static
This library allows to manipulate XML files.  It includes support
to read, modify and write XML and HTML files.  There is DTDs support
this includes parsing and validation even with complex DtDs, either
at parse time or later once the document has been modified.  The output
can be a simple SAX stream or and in-memory DOM like representations.
In this case one can use the built-in XPath and XPointer implementation
to select subnodes or ranges.  A flexible Input/Output mechanism is
available, with existing HTTP and FTP modules and combined to an
URI library.

This package contains the static library you can use to develop
statically linked applications manipulating XML files.

%description -n xml-utils
This package contains xml tools:
+ xmllint - utility for parsing and validating XML files;
+ xmlcatalog - command line tool to parse and manipulate XML or SGML
catalog files.

%description -n python-module-%name
This package contains a module that permits applications
written in the Python programming language to use the interface
supplied by the %name library to manipulate XML files.

This library allows to manipulate XML files.  It includes support
to read, modify and write XML and HTML files.  There is DTDs support
this includes parsing and validation even with complex DTDs, either
at parse time or later once the document has been modified.

%description doc
This package contains documentation on the XML C library.

%prep
%setup -n %srcname -a1
%patch -p1

%build
export ac_cv_path_WGET=/usr/bin/wget
export ac_cv_path_XMLLINT=/usr/bin/xmllint
export ac_cv_path_XSLTPROC=/usr/bin/xsltproc
# disable dependency on binutils-devel
export ac_cv_header_ansidecl_h=no
mkdir -p m4
%autoreconf
%configure \
    --with-python \
    --with-html-dir=%_docdir \
    --with-html-subdir=%name-%version \
    %{subst_enable static} \
    --disable-silent-rules

%make_build

%check
%make_build -k check

%install
%makeinstall_std

mv %buildroot%_datadir/aclocal/libxml{,2}.m4

%define pkgdocdir %_docdir/%name-%version
install -p -m644 AUTHORS Copyright NEWS README %buildroot%pkgdocdir/
install -p -m644 doc/*.html %buildroot%pkgdocdir/

%files
%_libdir/*.so.*
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/Copyright
%pkgdocdir/NEWS
%pkgdocdir/README

%files -n xml-utils
%_bindir/xmllint
%_bindir/xmlcatalog
%_man1dir/xmllint.*
%_man1dir/xmlcatalog.*

%files devel
%_bindir/*-config
%_libdir/*.so
%_libdir/*.sh
%_includedir/*
%_libdir/pkgconfig/*
%_datadir/aclocal/*
%_man1dir/*-config*
%_man3dir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif	#enabled static

%files -n python-module-%name
%python_sitelibdir/*
%dir %pkgdocdir
%dir %pkgdocdir/python
%pkgdocdir/python/TODO
%pkgdocdir/python/examples

%files doc
%dir %pkgdocdir
%pkgdocdir/*.html
%pkgdocdir/*.gif
%pkgdocdir/*.png
%pkgdocdir/*.xml
%pkgdocdir/*.xsl
%pkgdocdir/*.c
%pkgdocdir/*.res
%pkgdocdir/html
%pkgdocdir/examples
%pkgdocdir/tutorial
%doc %_datadir/gtk-doc/html/libxml2/

%changelog
