Name: libzeitgeist
Version: 0.3.18
Release: alt1

Summary: Client library for applications that want to interact with the Zeitgeist daemon

Group: System/Libraries
License: LGPLv3 and GPLv3
Url: https://launchpad.net/libzeitgeist

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://launchpad.net/%name/0.3/%version/+download/%name-%version.tar

Patch: %name-log_fix.patch

# zeitgeist is just a runtime and the reason to install libzeitgeist
Requires: zeitgeist

# Automatically added by buildreq on Tue Jul 12 2011
# optimized out: glib2-devel pkg-config
BuildRequires: glibc-devel gtk-doc libgio-devel

%description
This project provides a client library for applications that want to interact
with the Zeitgeist daemon. The library is written in C using glib and provides
an asynchronous GObject oriented API.

%package devel
Summary: Development files for %name
Group: Development/Other
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup
#patch0 -p1 -b .log

%build
%configure --disable-static
%make_build V=1

#check
#make check

%install
%makeinstall_std INSTALL="install -p"
install -d -p -m 755 %buildroot%_datadir/vala/vapi
install -D -p -m 644 bindings/zeitgeist-1.0.{vapi,deps} %buildroot%_datadir/vala/vapi
find %buildroot -name '*.la' -exec rm -f {} ';'

# remove duplicate documentation
rm -fr %buildroot%_docdir/%name

%files
# documentation
%doc COPYING COPYING.GPL README

# essential
%_libdir/*.so.*

%files devel
# Documentation
%doc AUTHORS ChangeLog COPYING COPYING.GPL MAINTAINERS NEWS
%doc examples/*.vala examples/*.c
%_datadir/gtk-doc/html/zeitgeist-1.0/

# essential
%_includedir/zeitgeist-1.0/
%_pkgconfigdir/zeitgeist-1.0.pc
%_libdir/*.so

# extra
%_datadir/vala/vapi/

%changelog
