%define origname linter
%define product 6.0.17
%define lprefix %_libexecdir
Name: %origname%product
Version: 19
Release: alt1.M70T.1
Vendor: RELEX, Inc


%define  utils_files \
linter%{product}/bin/dbf2lin \
linter%{product}/bin/dbstore \
linter%{product}/bin/inl \
linter%{product}/bin/inl.hlp \
linter%{product}/bin/ldba \
linter%{product}/bin/ldba.hlp_e \
linter%{product}/bin/ldba.hlp_k \
linter%{product}/bin/ldba.hlp_r \
linter%{product}/bin/ldba.hlp_u \
linter%{product}/bin/lhb \
linter%{product}/bin/lin2dbf \
linter%{product}/bin/loarel \
linter%{product}/bin/spc \
linter%{product}/bin/spman \
linter%{product}/x11wm/icons/ldba_48x48.xpm \
linter%{product}/x11wm/icons/inl_48x48.xpm
%define gui_files \
linter%{product}/bin/libexctrl.so.%{product}.%{version} \
linter%{product}/bin/libquerygen.so.%{product}.%{version} \
linter%{product}/bin/librelapi.so.%{product}.%{version} \
linter%{product}/bin/liblincpp.so.%{product}.%{version} \
linter%{product}/bin/dbsgui.rrs \
linter%{product}/bin/snmpmanager.rrs \
linter%{product}/bin/snmpmanager \
linter%{product}/bin/tdbx.rrs \
linter%{product}/bin/lindesk \
linter%{product}/x11wm/icons/lindesk_48x48.xpm \
linter%{product}/bin/migration.rrs \
linter%{product}/bin/dbcgui \
linter%{product}/bin/dbcgui.rrs \
linter%{product}/bin/typical.rrs \
linter%{product}/bin/querygenlib.rrs \
linter%{product}/bin/ld.rrs \
linter%{product}/bin/tdbx \
linter%{product}/bin/dbsgui \
linter%{product}/bin/migration \
linter%{product}/x11wm/icons/migration_48x48.xpm \
linter%{product}/bin/exctrl.rrs \
linter%{product}/bin/lhbx \
linter%{product}/x11wm/icons/lhb_48x48.xpm \
linter%{product}/bin/lhbx.rrs
%define netclnt_files \
linter%{product}/bin/edtab \
linter%{product}/bin/dbc_tcp \
linter%{product}/bin/nodetab 
%define server_files \
linter%{product}/bin/testdb \
linter%{product}/bin/loltp \
linter%{product}/bin/snmpset \
linter%{product}/bin/lldap \
linter%{product}/bin/hresctl \
linter%{product}/bin/snmptrapd \
linter%{product}/bin/snmpwalk \
linter%{product}/bin/sql \
linter%{product}/bin/snmpvacm \
linter%{product}/bin/intsrt \
linter%{product}/bin/chklinter \
linter%{product}/bin/srvcmd \
linter%{product}/bin/setlic \
linter%{product}/bin/linter \
linter%{product}/bin/tsp \
linter%{product}/bin/snmpusm \
linter%{product}/bin/lsyncd \
linter%{product}/bin/server \
linter%{product}/bin/shut \
linter%{product}/bin/linsnmp \
linter%{product}/bin/gendb \
linter%{product}/bin/lreplserver \
linter%{product}/bin/snmpgetnext \
linter%{product}/bin/snmptrap \
linter%{product}/bin/snmpget \
linter%{product}/bin/stproc \
linter%{product}/bin/dbs_tcp \
linter%{product}/bin/autosnap \
linter%{product}/bin/linapid \
linter%{product}/bin/linsnmpd \
linter%{product}/bin/dmbx \
linter%{product}/snmp \
linter%{product}/dict \
linter%{product}/scripts \
linter%{product}/samples/sql/soccer \
linter%{product}/samples/sql/date \
linter%{product}/samples/sql/auto \
linter%{product}/samples/db/lod \
linter%{product}/samples/proc \
linter%{product}/samples/triggers \
linter%{product}/db





License: distributable
Summary: RDMS LINTER
Summary(ru_RU.UTF-8): Система управления базами данных ЛИНТЕР
Group: Databases
Url: http://www.linter.ru
Packager: Oleg Galizin <galizin@altlinux.org>

Source1: linterx86.tar
Source2: linterx86_64.tar

BuildRequires(pre): rpm-build-licenses

BuildRequires: ncurses libreadline libldap rpm-build-licenses
BuildRequires: libssl libqt4 libqt4-sql gcc-c++ libstdc++
BuildRequires: libjpeg libpng awk findutils openssl 
BuildRequires: java-1.6.0-openjdk /proc libgssglue


%add_findreq_skiplist %lprefix/linter%{product}/perl-dbi/Linter.pm
%add_findreq_skiplist %lprefix/linter%{product}/perl/LinPerl.pm
%add_findreq_skiplist %lprefix/linter%{product}/samples/dbi/*.t
%add_findreq_skiplist %lprefix/linter%{product}/samples/perl/*.pl


Requires: linter-utils-%product = %version-%release
Requires: linter-server-%product = %version-%release
Requires: linter-netclnt-%product = %version-%release

%description
This is virtual packet to install Linter SQL.
The Linter SQL is a full SQL-92 compliant database with 
many SQL-99 features (BLOBS, triggers, save points, 
UDF'"'"'s). ODBC/JDBC/LinAPI interfaces,Stored Procedure/Triggers,
Referential integrity, Full transaction support, On-line Hot backup,
Full-text search functions, Synchronization features, Replication Module,
Predictable size Memory, Portable 

%description -l ru_RU.UTF-8
Виртуальный пакет СУБД ЛИНТЕР
Российская СУБД компании РЕЛЭКС, реализующая стандарт SQL-92 с поддержкой
большого количества операционных систем, включая Windows, различные версии
UNIX, QNX и др.

%package -n linter-server-%{product}
Summary: linter server
Summary(ru_RU.UTF-8): Система управления базами данных ЛИНТЕР. Сервер.
Group: Databases
Requires: libssl libtinfo
Requires: linter-utils-%{product} = %version-%release

%package -n linter-utils-%{product}
Summary: linter utilites
Summary(ru_RU.UTF-8): Система управления базами данных ЛИНТЕР. Утилиты
Group: Databases
Requires:libtinfo libreadline

%package -n linter-gui-%{product}
Summary: linter gui utilites
Summary(ru_RU.UTF-8): СУБД ЛИНТЕР. Графические утилиты
Group: Databases
Requires: libqt4-core libjpeg libpng zlib

%package -n linter-netclnt-%{product}
Summary: network client proxy
Summary(ru_RU.UTF-8): СУБД ЛИНТЕР. Сетовой драйвер клиента.
Group: Databases
Requires: libssl linter-utils-%{product} = %version-%release

%package -n linter-devel-%{product}
Summary: linter develop package
Summary(ru_RU.UTF-8): СУБД ЛИНТЕР. Пакет для разработки
Group: Databases
Requires: linter-server-%{product} = %version-%release perl-DBI

%description -n linter-server-%{product}
The Linter SQL is a full SQL-92 compliant database with 
many SQL-99 features (BLOBS, triggers, save points,
UDF'"'"'s). Utilites for adb assess and etc.
Demo database login is SYSTEM/MANAGER.

%description -l ru_RU.UTF-8 -n linter-server-%{product}
Российская СУБД компании РЕЛЭКС, реализующая стандарт SQL-92 с поддержкой
большого количества операционных систем, включая Windows, различные версии
UNIX, QNX и др. Логин для демонстрационной базы SYSTEM/MANAGER.


%description -n linter-utils-%{product}
The Linter SQL is a full SQL-92 compliant database with 
many SQL-99 features (BLOBS, triggers, save points, 
UDF'"'"'s). Utilites for adb assess and etc.

%description -l ru_RU.UTF-8 -n linter-utils-%{product}
Российская СУБД компании РЕЛЭКС, реализующая стандарт SQL-92 с поддержкой
большого количества операционных систем, включая Windows, различные версии
UNIX, QNX и др.

%description -n linter-gui-%{product}
The Linter SQL is a full SQL-92 compliant database with 
many SQL-99 features (BLOBS, triggers, save points, 
UDF'"'"'s). ODBC/JDBC/LinAPI interfaces,Stored Procedure/Triggers,
Referential integrity, Full transaction support, On-line Hot backup,
Full-text search functions, Synchronization features, Replication Module,
Predictable size Memory, Portable

%description -l ru_RU.UTF-8 -n linter-gui-%{product}
Российская СУБД компании РЕЛЭКС, реализующая стандарт SQL-92 с поддержкой
большого количества операционных систем, включая Windows, различные версии
UNIX, QNX и др.

%description -n linter-netclnt-%{product}
The Linter SQL is a full SQL-92 compliant database with 
many SQL-99 features (BLOBS, triggers, save points, 
UDF'"'"'s). ODBC/JDBC/LinAPI interfaces,Stored Procedure/Triggers,
Referential integrity, Full transaction support, On-line Hot backup,
Full-text search functions, Synchronization features, Replication Module,
Predictable size Memory, Portable 

%description -l ru_RU.UTF-8 -n linter-netclnt-%{product}
Российская СУБД компании РЕЛЭКС, реализующая стандарт SQL-92 с поддержкой
большого количества операционных систем, включая Windows, различные версии
UNIX, QNX и др.

%description -n linter-devel-%{product}
The Linter SQL is a full SQL-92 compliant database with 
many SQL-99 features (BLOBS, triggers, save points, 
UDF'"'"'s). ODBC/JDBC/LinAPI interfaces,Stored Procedure/Triggers,
Referential integrity, Full transaction support, On-line Hot backup,
Full-text search functions, Synchronization features, Replication Module,
Predictable size Memory, Portable 

%description -l ru_RU.UTF-8 -n linter-devel-%{product}
Российская СУБД компании РЕЛЭКС, реализующая стандарт SQL-92 с поддержкой
большого количества операционных систем, включая Windows, различные версии
UNIX, QNX и др.

%prep
ARC=`uname -m`
if [ $ARC = x86_64 ]; then
  tar xf %SOURCE2
else
  tar xf %SOURCE1
fi

tar xfz linter.tar.gz

%build

echo

%install

install -d %buildroot%lprefix
install -d %buildroot%_libdir
install -d %buildroot%_bindir
install -d %buildroot%_initdir
install -d %buildroot%_localstatedir/linter%{product}/db
install -d %buildroot%_localstatedir/linter%{product}/arc

cp -r linter %buildroot%lprefix/linter%{product}
rm %buildroot%lprefix/linter%{product}/uninstall.*

cat <<__EOF__ > %buildroot%{lprefix}/linter%{product}/bin/nodetab
#It is LINTER network client config file
#NODENAME PROTOCOL HOST      PORT TIMEOUT TIMEOUT TIMEOUT
#SRV       TCPIP    srv.com   1060 1       20      20
MY        TCPIP    localhost 1060 1       20      20
__EOF__

>%_builddir/linter.list

pushd %buildroot%{lprefix}
find linter%{product} > %_builddir/linter.list_
for i in `cat %_builddir/linter.list_`; do
  [ -d $i ] || echo $i >> %_builddir/linter.list
done
popd



create_links_for_so()
{
  file_list=$1;

  > $file_list.lib
  for i in `cat $file_list`; do
    [ -d "%buildroot%{lprefix}/$i" ] && continue
    echo $i | grep linter%{product}/bin || continue
    NAME=`echo $i | awk -F / '{print $NF}'`
    SO_SUFFIX=`echo $i | awk '/\.so/{print 1;}'`
    [ A"$SO_SUFFIX" = A ] || {
      ln -s "../..%lprefix/$i" %buildroot%_libdir/$NAME
      echo ln -s %lprefix/$i %buildroot%_libdir/$NAME
      echo %_libdir/$NAME >> $file_list.lib
      }
  done
}



cat <<__EOF__ > utils.list
%utils_files
__EOF__

cat <<__EOF__>%name-ldba.desktop
[Desktop Entry]
Encoding=UTF-8
Name=Linter Administrator (console) %{product}
Name[ru]=Администратор ЛИНТЕР(консольный) %{product}
Exec=sh -c '. %lprefix/linter%{product}/bin/config_lin.sh; export LINTER_MBX; %lprefix/linter%{product}/bin/ldba'
Terminal=1
Type=Application
Categories=Development;Database;
Icon=%lprefix/linter%{product}/x11wm/icons/ldba_48x48.xpm
__EOF__
install -pD -m644 %name-ldba.desktop %buildroot%_desktopdir/%name-ldba.desktop

cat <<__EOF__>%name-inl.desktop
[Desktop Entry]
Name=Linter interactive SQL (console) %{product}
Name[ru]=Интерактивный SQL ЛИНТЕР(консольный) %{product}
Exec=sh -c '". %lprefix/linter%{product}/bin/config_lin.sh; export LINTER_MBX;%lprefix/linter%{product}/bin/inl"'
Terminal=1
Type=Application
Categories=Development;Database;
Icon=%lprefix/linter%{product}/x11wm/icons/inl_48x48.xpm
__EOF__
install -pD -m644 %name-inl.desktop %buildroot%_desktopdir/%name-inl.desktop

#create_links utils.list


cat <<__EOF__ > gui.list
%gui_files
__EOF__

create_links_for_so gui.list

cat <<__EOF__>%name-lindesk.desktop
[Desktop Entry]
Name=Linter desktop %{product}
Name[ru]=Рабочий стол ЛИНТЕР %{product}
Exec=sh -c '. %lprefix/linter%{product}/bin/config_lin.sh; export LINTER_MBX;%lprefix/linter%{product}/bin/lindesk'
Type=Application
Categories=Development;Database;
Icon=%lprefix/linter%{product}/x11wm/icons/lindesk_48x48.xpm
__EOF__
install -pD -m644 %name-lindesk.desktop %buildroot%_desktopdir/%name-lindesk.desktop

cat <<__EOF__>%name-migration.desktop
[Desktop Entry]
Name=Linter data migration %{product}
Name[ru]=Загрузка/выгрузка текстовых файлов ЛИНТЕР %{product}
Exec=sh -c '. %lprefix/linter%{product}/bin/config_lin.sh; export LINTER_MBX;%lprefix/linter%{product}/bin/migration'
Type=Application
Categories=Development;Database;
Icon=%lprefix/linter%{product}/x11wm/icons/migration_48x48.xpm
__EOF__
install -pD -m644 %name-migration.desktop %buildroot%_desktopdir/%name-migration.desktop

cat <<__EOF__>%name-lhbx.desktop
[Desktop Entry]
Name=Linter hot backup %{product}
Name[ru]=Утилита горячего архивирования ЛИНТЕР %{product}
Exec=sh -c '. %lprefix/linter%{product}/bin/config_lin.sh; export LINTER_MBX;%lprefix/linter%{product}/bin/lhbx'
Type=Application
Categories=Development;Database;
Icon=%lprefix/linter%{product}/x11wm/icons/lhb_48x48.xpm
__EOF__
install -pD -m644 %name-lhbx.desktop %buildroot%_desktopdir/%name-lhbx.desktop

cat <<__EOF__ > netclnt.list
%netclnt_files
__EOF__

#create_links netclnt.list


cat <<__EOF__ > server.list
%server_files
__EOF__

#linter%{product}/license.txt

#create_links server.list


>gui.files
for i in `cat gui.list`; do
  echo %{lprefix}/$i >> gui.files
done
#cat gui.list.bin >> gui.files
cat gui.list.lib >> gui.files


>utils.files
for i in `cat utils.list`; do
  echo %{lprefix}/$i >> utils.files
done
#cat utils.list.bin >> utils.files

>netclnt.files
for i in `cat netclnt.list`; do
  echo %{lprefix}/$i >> netclnt.files
done
#cat netclnt.list.bin >> netclnt.files

>server.files
for i in `cat server.list`; do
  echo %lprefix/$i >> server.files
done
#cat server.list.bin >> server.files

cat <<'__EOF__' > %buildroot%lprefix/linter%{product}/bin/config_lin.sh

LINTER_DIR="%{lprefix}/linter%{product}"
LINTER_BIN="$LINTER_DIR"/bin
LINTER_MBX=20561
POOL=1000
SPOOL=500
SY00="%_localstatedir/linter%{product}/db"

RUN_DBS_TCP=1
NET_PORT=1060

RUN_DBC_TCP=0
NODETAB_FILE="$LINTER_BIN"/nodetab
NET_MBX=20562
DBC_PID_FILE="$LINTER_BIN"/dbc_tcp.pid

RUN_JDBC_SERVER=1
JDBC_SERVER_PORT=1070

RUN_SNMPD=0
SNMPD_PID_FILE="$LINTER_BIN"/linsnmpd.pid
SNMP_CONF_FILE="$LINTER_DIR"/snmp/snmp.conf

LHB_PID_FILE="$LINTER_BIN"/lhb.pid
LHB_LOG_FILE="$SY00"/lhb.log
__EOF__

cat << '__EOF__' > %buildroot%lprefix/linter%{product}/bin/private_passwd
USER="SYSTEM"
PASSWORD="MANAGER"
__EOF__

chmod og-r %buildroot%lprefix/linter%{product}/bin/private_passwd


cat <<'__EOF__' > %buildroot%lprefix/linter%{product}/bin/start_linter.sh
#!/bin/sh

LINTER_DIR="%{lprefix}/linter%{product}"

. "$LINTER_DIR"/bin/config_lin.sh

export LINTER_MBX NET_MBX

. "$LINTER_BIN"/private_passwd

is_running()
    {
    LINTER_NET_MBX=$NET_MBX
    NET_MBX=$LINTER_MBX
    export NET_MBX

    "$LINTER_BIN"/chklinter -r -u "\"$USER\""/"\"$PASSWORD\""
    rets=$?

    NET_MBX=$LINTER_NET_MBX
    export NET_MBX
    return $rets;
    };

cd "$SY00"

is_running && {
  echo "Linter is already running."
  exit 1
  }


TCP_OPT=""
[ -x "$LINTER_BIN"/dbs_tcp -a $RUN_DBS_TCP -eq 1 ] && {
  TCP_OPT="/TCP=$NET_PORT"
  }
      
JDBC_OPT=""
[ -x "$LINTER_BIN"/linapid -a $RUN_JDBC_SERVER -eq 1 ] && {
    JDBC_OPT="/JDBCS=\"$LINTER_DIR\"/jadm /JDBCP=$JDBC_SERVER_PORT"
    }
      
"$LINTER_BIN"/linter /BASE="$SY00" /POOL=$POOL /SPOOL=$SPOOL $TCP_OPT ${JDBC_OPT}
    
for i in 3 5 10 15; do
  sleep $i
  if is_running; then
    break
  fi
done

[ -f "$LHB_PID_FILE" ] && {
  kill `cat "$LHB_PID_FILE"`
  rm -f "$LHB_PID_FILE"
  }

[ -f "$LINTER_BIN"/backup.bsl -a -x "$LINTER_BIN"/lhb ] && {
  "$LINTER_BIN"/lhb script -ft "$LINTER_BIN"/backup.bsl -fl "$LHB_LOG_FILE" -mypid "$LHB_PID_FILE" -bg > /dev/null
  }

[ -f "$DBC_PID_FILE" ] && {
  kill `cat "$DBC_PID_FILE"`
  rm -f "$DBC_PID_FILE"
  }

[ $RUN_DBC_TCP -ne 0 -a -x "$LINTER_BIN"/dbc_tcp ] && {
  "$LINTER_BIN"/dbc_tcp /p="$DBC_PID_FILE" /n="$NODETAB_FILE"
  }

[ $RUN_SNMPD -ne 0 -a -x "$LINTER_BIN"/linsnmpd ] && {
  "$LINTER_BIN"/linsnmpd -c "$SNMP_CONF_FILE" -p "$SNMPD_PID_FILE"
  }

[ -x "$LINTER_BIN"/async_start.sh -a "$NO_AR"A = A ] && "$LINTER_BIN"/async_start.sh

exit 0

__EOF__

cat <<'__EOF__' > %buildroot%lprefix/linter%{product}/bin/stop_linter.sh
#!/bin/sh

LINTER_DIR="%{lprefix}/linter%{product}"

. "$LINTER_DIR"/bin/config_lin.sh

export LINTER_MBX NET_MBX

. "$LINTER_BIN"/private_passwd

is_running()
    {
    LINTER_NET_MBX=$NET_MBX
    NET_MBX=$LINTER_MBX
    export NET_MBX

    "$LINTER_BIN"/chklinter -r -u "\"$USER\""/"\"$PASSWORD\""
    rets=$?

    NET_MBX=$LINTER_NET_MBX
    export NET_MBX
    return $rets;
    };

[ -x "$LINTER_BIN"/async_stop.sh -a "$NO_AR"A = A ] && "$LINTER_BIN"/async_stop.sh

cd "$SY00"
is_running || {
  echo "Linter is not running"
  exit 1
  }


[ -f "$DBC_PID_FILE" ] && {
  kill `cat "$DBC_PID_FILE"`
  rm -f "$DBC_PID_FILE"
  }

"$LINTER_BIN"/shut -u "\"$USER\""/"\"$PASSWORD\"" -r &

for i in 1 3 5 10 20; do
  if is_running;then
    sleep $i
  fi
done

if [ -f "$LHB_PID_FILE" ]; then
  kill `cat "$LHB_PID_FILE"`
  rm -f "$LHB_PID_FILE"
fi

if [ -f "$SNMPD_PID_FILE" ]; then
  kill `cat "$SNMPD_PID_FILE"`
  rm -f "$SNMPD_PID_FILE"
fi


__EOF__

chmod a+x %buildroot%lprefix/linter%{product}/bin/start_linter.sh
chmod a+x %buildroot%lprefix/linter%{product}/bin/stop_linter.sh

cat <<'__EOF__' > %buildroot%_initdir/linter%{product}
#!/bin/sh
# chkconfig: 2345 90 05
# description: linter sql server kernel and some components
# processname: linter

   

# Source function library.
WITHOUT_RC_COMPAT=1
. /etc/rc.d/init.d/functions
    
LOCKFILE=/var/lock/subsys/linter%{product}

LINTER_DIR="%{lprefix}/linter%{product}"

start()
{
	msg_starting $"Start RDBMS Linter SQL %{product}"

        start-stop-daemon --name linter --start --exec "%{lprefix}/linter%{product}/bin/start_linter.sh" && touch $LOCKFILE
	RETVAL=$?
	return $RETVAL
}

stop()
{
	msg_stopping $"Stop RDBMS Linter SQL %{product}"
        start-stop-daemon --stop --test --name linter --quiet && "%{lprefix}/linter%{product}/bin/stop_linter.sh"
	RETVAL=$?
	rm -f $LOCKFILE
	return $RETVAL
}

    

case "$1" in
  start)
    start
    ;;

  stop)
    stop
    ;;
    
  restart|reload)
    stop
    start
    ;;
  condstop)
    if [ -f "$LOCKFILE" ]; then
      stop
    fi
    ;;
  
  condrestart)
    if [ -f "$LOCKFILE" ]; then
      stop
      start
    fi
    ;;
  *)
    echo "Usage: linter%{product} {start|stop|restart}"
    ;;
  esac
  exit 0
__EOF__

chmod a+x %buildroot%_initdir/linter%{product}


cat server.files netclnt.files utils.files gui.files | awk ' {gsub("/","\\/",$1);print "/^"$1"/{next}"; next}' > 111.awk
echo '{print $0}' >> 111.awk

for i in `cat %_builddir/linter.list `; do echo "%lprefix"/$i; done | awk -f 111.awk > devel.files

echo %_initdir/linter%{product} >> server.files
echo %%config %lprefix/linter%{product}/bin/config_lin.sh >> utils.files
echo %%config %lprefix/linter%{product}/bin/private_passwd >> server.files
echo %lprefix/linter%{product}/bin/start_linter.sh >> server.files
echo %lprefix/linter%{product}/bin/stop_linter.sh >> server.files
echo %_localstatedir/linter%{product}/db >> server.files
echo %%dir %_localstatedir/linter%{product}/arc >> server.files
echo %_desktopdir/%name-ldba.desktop >>utils.files
echo %_desktopdir/%name-inl.desktop >>utils.files
echo %_desktopdir/%name-lindesk.desktop >>gui.files
echo %_desktopdir/%name-lhbx.desktop >>gui.files
echo %_desktopdir/%name-migration.desktop >>gui.files

%post -n linter-utils-%{product}
#echo  postinstall $1 linter-utils-%{product} %release
[ $1 -eq 2 ] && exit #update
create_links()
{
  file_list=$1;

  for i in $file_list; do
    [ -d "%{lprefix}/$i" ] && continue #it is directory
    echo $i | grep linter%{product}/bin >/dev/null || continue #it is not bin directory

    NAME=`echo $i | awk -F / '{print $NF}'`
    SO_SUFFIX=`echo $i | awk '/\.so/{print 1;}'`
    RRS_SUFFIX=`echo $i | awk '/\.rrs/{print 1;}'`
    link_exist=`ls -l %_bindir/$NAME 2>/dev/null | awk 'BEGIN{a=0}/\/linter/{a=1}END{print a;}'`
    [ -x "%{lprefix}/$i" ] && [ A"$SO_SUFFIX" = A ] && {
          [ A`echo $i | awk '/snmpmanager/{exit;} /^snmp/{print 1;}'` = A ] || continue #for all executeble but not snmp
          [ $link_exist -eq 1 ] && continue
          ln -s "%{lprefix}/$i" %_bindir/$NAME
          }
    [ A"$RRS_SUFFIX" = A ] || {
          [ $link_exist -eq 1 ] && continue
          ln -s "%{lprefix}/$i" %_bindir/$NAME
          }
  done
}
[ -L %_bindir/ldba ] && { #The other linter product is already installed

cat <<'__EOF__' > %_desktopdir/%name-two-linter.desktop
[Desktop Entry]
Encoding=UTF-8
Name=Linter two products readme %{product}
Name[ru]=Readme установка нескольких продуктов %{product}
Exec=sh -c 'if locale | grep ru_RU > /dev/null; then less //opt/linter6.0.18/bin/two_linter_readme_ru_utf8.txt; else less //opt/linter6.0.18/bin/two_linter_readme.txt; fi'
Categories=Development;Database;
Terminal=1
Type=Application
__EOF__

echo '
This is the second RSBMS LINTER on this host. To correct work
of the program please change environment variables
LINTER_MBX, NET_PORT, NET_MBX, JDBC_SERVER_PORT in file
%lprefix/linter%{product}/bin/config_lin.sh to other
values.
' > %lprefix/linter%{product}/bin/two_linter_readme.txt
echo 'На данной машине установлено два экземпляра СУБД ЛИНТЕР.
Что бы второй экземпляр работал корректно необходимо изменить 
значения переменных окружения LINTER_MBX, NET_PORT, NET_MBX, 
JDBC_SERVER_PORT в файле %lprefix/linter%{product}/bin/config_lin.sh
' > %lprefix/linter%{product}/bin/two_linter_readme_ru_utf8.txt
}
create_links '%utils_files'

%post -n linter-gui-%{product}
#echo postinstall $1 linter-gui-%{product}  %release
[ $1 -eq 2 ] && exit #update
create_links()
{
  file_list=$1;

  for i in $file_list; do
    [ -d "%{lprefix}/$i" ] && continue #it is directory
    echo $i | grep linter%{product}/bin >/dev/null || continue #it is not bin directory

    NAME=`echo $i | awk -F / '{print $NF}'`
    SO_SUFFIX=`echo $i | awk '/\.so/{print 1;}'`
    RRS_SUFFIX=`echo $i | awk '/\.rrs/{print 1;}'`
    link_exist=`ls -l %_bindir/$NAME 2>/dev/null | awk 'BEGIN{a=0}/\/linter/{a=1}END{print a;}'`
    [ -x "%{lprefix}/$i" ] && [ A"$SO_SUFFIX" = A ] && {
          [ A`echo $i | awk '/snmpmanager/{exit;} /^snmp/{print 1;}'` = A ] || continue #for all executeble but not snmp
          [ $link_exist -eq 1 ] && continue
          ln -s "%{lprefix}/$i" %_bindir/$NAME
          }
    [ A"$RRS_SUFFIX" = A ] || {
          [ $link_exist -eq 1 ] && continue
          ln -s "%{lprefix}/$i" %_bindir/$NAME
          }
  done
}
create_links '%gui_files'

%post -n linter-netclnt-%{product}
#echo postinstall $1 linter-netclnt-%{product} %release
[ $1 -eq 2 ] && exit #update
create_links()
{
  file_list=$1;

  for i in $file_list; do
    [ -d "%{lprefix}/$i" ] && continue #it is directory
    echo $i | grep linter%{product}/bin >/dev/null || continue #it is not bin directory

    NAME=`echo $i | awk -F / '{print $NF}'`
    SO_SUFFIX=`echo $i | awk '/\.so/{print 1;}'`
    RRS_SUFFIX=`echo $i | awk '/\.rrs/{print 1;}'`
    link_exist=`ls -l %_bindir/$NAME 2>/dev/null | awk 'BEGIN{a=0}/\/linter/{a=1}END{print a;}'`
    [ -x "%{lprefix}/$i" ] && [ A"$SO_SUFFIX" = A ] && {
          [ A`echo $i | awk '/snmpmanager/{exit;} /^snmp/{print 1;}'` = A ] || continue #for all executeble but not snmp
          [ $link_exist -eq 1 ] && continue
          ln -s "%{lprefix}/$i" %_bindir/$NAME
          }
    [ A"$RRS_SUFFIX" = A ] || {
          [ $link_exist -eq 1 ] && continue
          ln -s "%{lprefix}/$i" %_bindir/$NAME
          }
  done
}
create_links '%netclnt_files'


%preun -n linter-utils-%{product}
#echo preun $1 linter-utils-%{product}  %release
[ $1 -eq 1 ] && exit #update
remove_links()
{
  file_list=$1;

  for i in $file_list; do
    [ -d "%{lprefix}/$i" ] && continue #it is directory
    echo $i | grep linter%{product}/bin >/dev/null || continue #it is not bin directory

    NAME=`echo $i | awk -F / '{print $NF}'`
    SO_SUFFIX=`echo $i | awk '/\.so/{print 1;}'`
    RRS_SUFFIX=`echo $i | awk '/\.rrs/{print 1;}'`
    link_exist=`ls -l %_bindir/$NAME 2>/dev/null | awk 'BEGIN{a=0}/\/linter%{product}\/bin\/'$NAME'/{a=1}END{print a;}'`
    [ -x "%{lprefix}/$i" ] && [ A"$SO_SUFFIX" = A ] && {
          [ $link_exist -eq 1 ] && rm -f %_bindir/$NAME
          }
    [ A"$RRS_SUFFIX" = A ] || {
          [ $link_exist -eq 1 ] && rm -f %_bindir/$NAME
          }
  done
}
rm -f %lprefix/linter%{product}/bin/two_linter_readme.txt
rm -f %lprefix/linter%{product}/bin/two_linter_readme_ru_utf8.txt
rm -f %_desktopdir/%name-two-linter.desktop
remove_links '%utils_files'
exit 0

%preun -n linter-gui-%{product}
#echo preun $1 linter-gui-%{product}  %release
[ $1 -eq 1 ] && exit #update
remove_links()
{
  file_list=$1;

  for i in $file_list; do
    [ -d "%{lprefix}/$i" ] && continue #it is directory
    echo $i | grep linter%{product}/bin >/dev/null || continue #it is not bin directory

    NAME=`echo $i | awk -F / '{print $NF}'`
    SO_SUFFIX=`echo $i | awk '/\.so/{print 1;}'`
    RRS_SUFFIX=`echo $i | awk '/\.rrs/{print 1;}'`
    link_exist=`ls -l %_bindir/$NAME 2>/dev/null | awk 'BEGIN{a=0}/\/linter%{product}\/bin\/'$NAME'/{a=1}END{print a;}'`
    [ -x "%{lprefix}/$i" ] && [ A"$SO_SUFFIX" = A ] && {
          [ $link_exist -eq 1 ] && rm -f %_bindir/$NAME
          }
    [ A"$RRS_SUFFIX" = A ] || {
          [ $link_exist -eq 1 ] && rm -f %_bindir/$NAME
          }
  done
}
remove_links '%gui_files'
exit 0

%preun -n linter-netclnt-%{product}
#echo preun $1 linter-netclnt-%{product}  %release
[ $1 -eq 1 ] && exit #update
remove_links()
{
  file_list=$1;

  for i in $file_list; do
    [ -d "%{lprefix}/$i" ] && continue #it is directory
    echo $i | grep linter%{product}/bin >/dev/null || continue #it is not bin directory

    NAME=`echo $i | awk -F / '{print $NF}'`
    SO_SUFFIX=`echo $i | awk '/\.so/{print 1;}'`
    RRS_SUFFIX=`echo $i | awk '/\.rrs/{print 1;}'`
    link_exist=`ls -l %_bindir/$NAME 2>/dev/null | awk 'BEGIN{a=0}/\/linter%{product}\/bin\/'$NAME'/{a=1}END{print a;}'`
    [ -x "%{lprefix}/$i" ] && [ A"$SO_SUFFIX" = A ] && {
          [ $link_exist -eq 1 ] && rm -f %_bindir/$NAME
          }
    [ A"$RRS_SUFFIX" = A ] || {
          [ $link_exist -eq 1 ] && rm -f %_bindir/$NAME
          }
  done
}
remove_links '%netclnt_files'
exit 0

%pre -n linter-server-%{product}
#echo preinstall $1 linter-server-%{product}  %release
[ $1 -ne 2 ] && exit #! update
/sbin/service linter%{product} condstop ||:


%post -n linter-server-%{product}
#echo postinstall $1 linter-server-%{product}  %release
[ $1 -eq 2 ] && exit # update 
create_links()
{
  file_list=$1;

  for i in $file_list; do
    [ -d "%{lprefix}/$i" ] && continue #it is directory
    echo $i | grep linter%{product}/bin >/dev/null || continue #it is not bin directory

    NAME=`echo $i | awk -F / '{print $NF}'`
    SO_SUFFIX=`echo $i | awk '/\.so/{print 1;}'`
    RRS_SUFFIX=`echo $i | awk '/\.rrs/{print 1;}'`
    link_exist=`ls -l %_bindir/$NAME 2>/dev/null | awk 'BEGIN{a=0}/\/linter/{a=1}END{print a;}'`
    [ -x "%{lprefix}/$i" ] && [ A"$SO_SUFFIX" = A ] && {
          [ A`echo $i | awk '/snmpmanager/{exit;} /^snmp/{print 1;}'` = A ] || continue #for all executeble but not snmp
          [ $link_exist -eq 1 ] && continue
          ln -s "%{lprefix}/$i" %_bindir/$NAME
          }
    [ A"$RRS_SUFFIX" = A ] || {
          [ $link_exist -eq 1 ] && continue
          ln -s "%{lprefix}/$i" %_bindir/$NAME
          }
  done
}
install -d %_localstatedir/linter%{product}/db
install -d %_localstatedir/linter%{product}/arc
cp %lprefix/linter%{product}/db/*.?1 %_localstatedir/linter%{product}/db
%post_service linter%{product}
/sbin/chkconfig --add linter%{product} ||:
#/sbin/service linter%{product} start ||:
RU=NO
[ -f /etc/locale.conf ] && cat /etc/locale.conf | grep ru_RU >/dev/null && RU=YES
[ -f /etc/sysconfig/i18n ] && cat /etc/sysconfig/i18n | grep ru_RU >/dev/null && RU=YES
[ $RU = YES ] && { 
  #Run linter
  SY00=%_localstatedir/linter%{product}/db
  export SY00
  LINTER_MBX=1234
  export LINTER_MBX

  AUTOCONFIG=`%{lprefix}/linter%{product}/bin/gendb -get AUTOCONFIG`
  echo 'set autoconfig off; exit'|%{lprefix}/linter%{product}/bin/gendb >/dev/null
  %{lprefix}/linter%{product}/bin/linter /pool=1000 >/dev/null
  for SL in 1 3 5 10 20 30; do
    %{lprefix}/linter%{product}/bin/chklinter -r >/dev/null && break
    sleep $SL
  done

  echo 'set database names "CP1251";'| %{lprefix}/linter%{product}/bin/inl -u SYSTEM/MANAGER >/dev/null;
  echo 'set database default character set "CP1251";'| %{lprefix}/linter%{product}/bin/inl -u SYSTEM/MANAGER >/dev/null;
  
  %{lprefix}/linter%{product}/bin/shut -u SYSTEM/MANAGER >/dev/null
  echo 'set autoconfig '$AUTOCONFIG'; exit' | %{lprefix}/linter%{product}/bin/gendb >/dev/null
  } ||:
create_links '%server_files'

%preun -n linter-server-%{product}
#echo preun $1 linter-server-%{product}  %release
[ $1 -eq 1 ] && exit # update
%preun_service linter%{product}
/sbin/chkconfig --del linter%{product} ||:
rm -f %_localstatedir/linter%{product}/db/*

remove_links()
{
  file_list=$1;

  for i in $file_list; do
    [ -d "%{lprefix}/$i" ] && continue #it is directory
    echo $i | grep linter%{product}/bin >/dev/null || continue #it is not bin directory

    NAME=`echo $i | awk -F / '{print $NF}'`
    SO_SUFFIX=`echo $i | awk '/\.so/{print 1;}'`
    RRS_SUFFIX=`echo $i | awk '/\.rrs/{print 1;}'`
    link_exist=`ls -l %_bindir/$NAME 2>/dev/null | awk 'BEGIN{a=0}/\/linter%{product}\/bin\/'$NAME'/{a=1}END{print a;}'`
    [ -x "%{lprefix}/$i" ] && [ A"$SO_SUFFIX" = A ] && {
          [ $link_exist -eq 1 ] && rm -f %_bindir/$NAME
          }
    [ A"$RRS_SUFFIX" = A ] || {
          [ $link_exist -eq 1 ] && rm -f %_bindir/$NAME
          }
  done
}
remove_links '%server_files'
exit 0


%files -f server.files -n linter-server-%{product}
%doc license.txt

%files -f devel.files -n linter-devel-%{product}
%doc license.txt

%files -f utils.files -n linter-utils-%{product}
%doc license.txt

%files -f gui.files -n linter-gui-%{product}
%doc license.txt

%files -f netclnt.files -n linter-netclnt-%{product}
%doc license.txt

%files
%doc license.txt


%changelog
